/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.assets.io;

import de.ti2010.mars.assets.core.Asset;
import de.ti2010.mars.assets.core.Composite;
import de.ti2010.mars.assets.core.Material;
import de.ti2010.mars.assets.core.Mesh;
import de.ti2010.mars.assets.core.Sound;
import de.ti2010.mars.assets.core.Texture;
import de.ti2010.mars.assets.io.AssetDescriptor;
import de.ti2010.mars.assets.io.AssetLoaderException;
import de.ti2010.mars.assets.io.pipe.AbstractPipeOperator;
import de.ti2010.mars.assets.io.pipe.MeshPipe;
import de.ti2010.mars.assets.io.pipe.TexturePipe;
import de.ti2010.mars.assets.io.pipe.impl.PipeFactory;
import de.ti2010.mars.assets.io.pipe.operators.DefaultOperatorMappings;
import de.ti2010.mars.assets.io.pipe.operators.OperatorMappings;
import de.ti2010.mars.io.Source;

public class AssetLoader {
    private static AssetLoader loader;
    private PipeFactory pipes = PipeFactory.getInstance();
    private OperatorMappings operatorMappings = DefaultOperatorMappings.getInstance();

    private AssetLoader() {
    }

    public static AssetLoader getInstance() {
        if (loader == null) {
            loader = new AssetLoader();
        }
        return loader;
    }

    public void load(Asset asset) {
        asset.load(this);
    }

    public void loadMaterial(Material material) {
    }

    public void loadMesh(Mesh mesh) {
        Source source = this.check(mesh);
        MeshPipe meshPipe = this.pipes.createMeshPipe();
        AbstractPipeOperator<Mesh, MeshPipe> abstractPipeOperator = this.operatorMappings.createMeshPipeOperators(source);
        abstractPipeOperator.apply(mesh, meshPipe);
    }

    public void loadTexture(Texture texture) {
        Source source = this.check(texture);
        TexturePipe texturePipe = this.pipes.createTexturePipe();
        AbstractPipeOperator<Texture, TexturePipe> abstractPipeOperator = this.operatorMappings.createTexturePipeOperators(source);
        abstractPipeOperator.apply(texture, texturePipe);
    }

    public void loadSound(Sound sound) {
    }

    public void loadComposite(Composite composite) {
        for (Asset asset : composite) {
            asset.load(this);
        }
    }

    private Source check(Asset asset) {
        if (asset.getDescriptor() == null) {
            throw new AssetLoaderException("Can not load an asset which has no descriptor associated!");
        }
        Source source = ((AssetDescriptor)asset.getDescriptor()).getSource();
        if (source == null) {
            throw new AssetLoaderException("Can not load an asset which has no source associated!");
        }
        return source;
    }
}

