/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.assets.io.pipe.operators;

import de.ti2010.mars.assets.core.Mesh;
import de.ti2010.mars.assets.core.VertexBuffer;
import de.ti2010.mars.assets.io.MeshDescriptor;
import de.ti2010.mars.assets.io.pipe.AbstractPipeOperator;
import de.ti2010.mars.assets.io.pipe.MeshPipe;
import java.nio.Buffer;

class MeshPipeFinalizeOperator
extends AbstractPipeOperator<Mesh, MeshPipe> {
    private PositionOperator po = new PositionOperator();
    private IndexOperator io = new IndexOperator();
    private TextureCoordinateOperator tco = new TextureCoordinateOperator();

    public MeshPipeFinalizeOperator() {
    }

    public MeshPipeFinalizeOperator(AbstractPipeOperator<Mesh, MeshPipe> abstractPipeOperator) {
        super(abstractPipeOperator);
    }

    @Override
    protected boolean operate(Mesh mesh, MeshPipe meshPipe) {
        mesh.initialize(((MeshDescriptor)mesh.getDescriptor()).getMode());
        this.po.operate(mesh, meshPipe);
        this.tco.operate(mesh, meshPipe);
        this.io.operate(mesh, meshPipe);
        return true;
    }

    private static class TextureCoordinateOperator {
        private TextureCoordinateOperator() {
        }

        public boolean operate(Mesh mesh, MeshPipe meshPipe) {
            Buffer buffer = meshPipe.getBuffer(VertexBuffer.Type.TexturCoordinate);
            if (buffer != null && buffer.capacity() > 0 && buffer.limit() > 0) {
                buffer.rewind();
                VertexBuffer vertexBuffer = mesh.getVertexBuffer(VertexBuffer.Type.TexturCoordinate);
                vertexBuffer.initialize(VertexBuffer.Format.Float, VertexBuffer.Type.TexturCoordinate, VertexBuffer.Usage.Static, 2, buffer);
            }
            return true;
        }
    }

    private static class IndexOperator {
        private IndexOperator() {
        }

        public boolean operate(Mesh mesh, MeshPipe meshPipe) {
            Buffer buffer = meshPipe.getBuffer(VertexBuffer.Type.Index);
            if (buffer != null && buffer.capacity() > 0 && buffer.limit() > 0) {
                buffer.rewind();
                VertexBuffer vertexBuffer = mesh.getVertexBuffer(VertexBuffer.Type.Index);
                vertexBuffer.initialize(VertexBuffer.Format.Integer, VertexBuffer.Type.Index, VertexBuffer.Usage.Static, 3, buffer);
            }
            return true;
        }
    }

    private static class PositionOperator {
        private PositionOperator() {
        }

        public boolean operate(Mesh mesh, MeshPipe meshPipe) {
            Buffer buffer = meshPipe.getBuffer(VertexBuffer.Type.Position);
            if (buffer != null && buffer.capacity() > 0 && buffer.limit() > 0) {
                buffer.rewind();
                VertexBuffer vertexBuffer = mesh.getVertexBuffer(VertexBuffer.Type.Position);
                vertexBuffer.initialize(VertexBuffer.Format.Float, VertexBuffer.Type.Position, VertexBuffer.Usage.Static, 4, buffer);
            }
            return true;
        }
    }
}

