/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.assets.io.pipe.operators;

import de.matthiasmann.twl.utils.PNGDecoder;
import de.ti2010.mars.assets.core.Texture;
import de.ti2010.mars.assets.io.pipe.AbstractPipeOperator;
import de.ti2010.mars.assets.io.pipe.TexturePipe;
import de.ti2010.mars.assets.io.pipe.operators.OperatorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

class PNGTextureDecodeOperator
extends AbstractPipeOperator<Texture, TexturePipe> {
    private ByteBuffer buf = null;
    int width = 0;
    int height = 0;

    public PNGTextureDecodeOperator() {
    }

    public PNGTextureDecodeOperator(AbstractPipeOperator<Texture, TexturePipe> abstractPipeOperator) {
        super(abstractPipeOperator);
    }

    @Override
    public boolean operate(Texture texture, TexturePipe texturePipe) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((ByteBuffer)texturePipe.getData()).array());
            PNGDecoder pNGDecoder = new PNGDecoder(byteArrayInputStream);
            this.width = pNGDecoder.getWidth();
            this.height = pNGDecoder.getHeight();
            if (!pNGDecoder.hasAlpha()) {
                throw new OperatorException("A PNG source for textures has to have an alpha channel!");
            }
            this.buf = ByteBuffer.allocateDirect(4 * this.width * this.height);
            pNGDecoder.decode(this.buf, this.width * 4, PNGDecoder.Format.RGBA);
            this.buf.flip();
            texturePipe.setWidth(this.width);
            texturePipe.setHeight(this.height);
            texturePipe.setType(Texture.Type.Texture2D);
            texturePipe.setPixelType(Texture.PixelType.RGBA);
            texturePipe.setData(this.buf);
            byteArrayInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Fehler beim Erstellen des PNGDecoders!");
            iOException.printStackTrace();
        }
        return true;
    }
}

