/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.gfx.core.impl;

import de.ti2010.mars.assets.core.Mesh;
import de.ti2010.mars.assets.core.VertexBuffer;
import de.ti2010.mars.assets.io.AssetLoader;
import de.ti2010.mars.assets.io.MeshDescriptor;
import de.ti2010.mars.gfx.Util;
import de.ti2010.mars.gfx.core.NativeMesh;
import de.ti2010.mars.gfx.core.NativeVertexBuffer;
import de.ti2010.mars.gfx.core.impl.NativeVertexBufferImpl;
import de.ti2010.mars.gfx.gl.GL;
import java.nio.Buffer;

class NativeMeshImpl
implements NativeMesh {
    private GL gl;
    private int handle = -1;
    private MeshDescriptor descriptor;
    private Mesh.Mode mode;
    private NativeVertexBuffer[] buffers = new NativeVertexBuffer[VertexBuffer.Type.values().length];

    public NativeMeshImpl() {
        this.descriptor = new MeshDescriptor();
        for (int i = 0; i < this.buffers.length; ++i) {
            this.buffers[i] = new MeshVertexBufferImpl();
        }
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public MeshDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void load(AssetLoader assetLoader) {
        assetLoader.loadMesh(this);
    }

    @Override
    public void initialize(Mesh.Mode mode) {
        if (this.isInitialized()) {
            throw new IllegalStateException("Mesh has already been initialized!");
        }
        this.gl = GL.getInstance();
        this.handle = this.gl.glGenVertexArrays();
        this.mode = mode;
    }

    @Override
    public boolean isInitialized() {
        return this.handle != -1;
    }

    @Override
    public VertexBuffer getVertexBuffer(VertexBuffer.Type type) {
        return this.buffers[type.ordinal()];
    }

    @Override
    public void bind() {
        this.gl.glBindVertexArray(this.handle);
    }

    @Override
    public void unbind() {
        this.gl.glBindVertexArray(0);
    }

    @Override
    public void enable() {
        for (NativeVertexBuffer nativeVertexBuffer : this.buffers) {
            if (nativeVertexBuffer == null || !nativeVertexBuffer.isInitialized() || nativeVertexBuffer.getType() == VertexBuffer.Type.Index) continue;
            this.gl.glEnableVertexAttribArray(nativeVertexBuffer.getType().ordinal());
        }
    }

    @Override
    public void disable() {
        for (NativeVertexBuffer nativeVertexBuffer : this.buffers) {
            if (nativeVertexBuffer == null || !nativeVertexBuffer.isInitialized() || nativeVertexBuffer.getType() == VertexBuffer.Type.Index) continue;
            this.gl.glDisableVertexAttribArray(nativeVertexBuffer.getType().ordinal());
        }
    }

    @Override
    public void setUsage(VertexBuffer.Usage usage) {
        for (NativeVertexBuffer nativeVertexBuffer : this.buffers) {
            if (nativeVertexBuffer == null) continue;
            nativeVertexBuffer.setUsage(usage);
        }
    }

    @Override
    public Mesh.Mode getMode() {
        return this.mode;
    }

    @Override
    public void free() {
    }

    private class MeshVertexBufferImpl
    extends NativeVertexBufferImpl {
        private MeshVertexBufferImpl() {
        }

        @Override
        public void initialize(VertexBuffer.Format format, VertexBuffer.Type type, VertexBuffer.Usage usage, int n, Buffer buffer) {
            super.initialize(format, type, usage, n, buffer);
            if (this.getType() != VertexBuffer.Type.Index) {
                NativeMeshImpl.this.bind();
                this.bind();
                NativeMeshImpl.this.gl.glVertexAttribPointer(this.getType().ordinal(), this.getComponents(), Util.glFormat(this.getFormat()), false, 0, 0);
                this.unbind();
                NativeMeshImpl.this.unbind();
            }
        }
    }
}

