/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.gfx.core.impl;

import de.ti2010.mars.assets.core.Texture;
import de.ti2010.mars.assets.io.AssetLoader;
import de.ti2010.mars.assets.io.TextureDescriptor;
import de.ti2010.mars.gfx.Util;
import de.ti2010.mars.gfx.core.NativeTexture;
import de.ti2010.mars.gfx.gl.GL;
import java.nio.Buffer;
import java.nio.ByteBuffer;

class NativeTextureImpl
implements NativeTexture {
    protected int handle;
    protected GL gl;
    protected TextureDescriptor descriptor = new TextureDescriptor();
    protected Texture.PixelType pixelType;
    protected Texture.Type type;
    protected int width;
    protected int height;
    protected ByteBuffer buf;

    @Override
    public void initialize(Texture.Type type, Texture.PixelType pixelType, int n, int n2, Buffer buffer) {
        this.pixelType = pixelType;
        this.type = type;
        this.width = n;
        this.height = n2;
        this.buf = (ByteBuffer)buffer;
        this.gl = GL.getInstance();
        this.handle = this.gl.glGenTextures();
        this.select(33984);
        this.bind();
        this.gl.glPixelStorei(3317, 1);
        this.unbind();
    }

    @Override
    public TextureDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public boolean isInitialized() {
        return this.handle != -1;
    }

    @Override
    public Texture.Type getType() {
        return this.type;
    }

    @Override
    public Texture.PixelType getPixelType() {
        return this.pixelType;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void bind() {
        this.gl.glBindTexture(Util.glTexture(this.type), this.handle);
    }

    @Override
    public void unbind() {
        this.gl.glBindTexture(Util.glTexture(this.type), 0);
    }

    @Override
    public void select(int n) {
        this.gl.glActiveTexture(n);
    }

    @Override
    public void buffer() {
        this.gl.glTexImage2D(Util.glTexture(this.type), 0, 32856, this.width, this.height, 0, Util.glPixelType(this.pixelType), 5121, this.buf);
    }

    @Override
    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public void load(AssetLoader assetLoader) {
        assetLoader.loadTexture(this);
    }

    @Override
    public void free() {
    }
}

