/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.gfx.core.impl;

import de.ti2010.mars.assets.core.Texture;
import de.ti2010.mars.assets.core.VertexBuffer;
import de.ti2010.mars.gfx.Util;
import de.ti2010.mars.gfx.core.NativeUIFrame;
import de.ti2010.mars.gfx.gl.GL;
import de.ti2010.mars.ui.UIComponent;
import de.ti2010.mars.ui.UIFrame;
import de.ti2010.mars.util.Synchronizer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL11;

public class NativeUIFrameImpl
extends UIFrame
implements NativeUIFrame {
    private GL gl;
    private int handle;
    private int texHandle;
    private int pHandle;
    private int iHandle;
    private int uvHandle;
    private FloatBuffer positions;
    private IntBuffer indices;
    private FloatBuffer coordinates;
    private ByteBuffer textureBuffer;
    private BufferedImage textureImage;
    private int z = 1;
    private InternalRenderThread thread;
    private Synchronizer sync;

    @Override
    public void initialize(int n, int n2, int n3, int n4) {
        this.x = -n3 / 2 + n;
        this.y = n4 / 2 + n2;
        this.width = n3;
        this.height = n4;
        this.background = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        this.positions = ByteBuffer.allocateDirect(96).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.indices = ByteBuffer.allocateDirect(24).order(ByteOrder.nativeOrder()).asIntBuffer();
        this.coordinates = ByteBuffer.allocateDirect(48).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.textureBuffer = ByteBuffer.allocateDirect(n3 * n4 * 4);
        this.indices.put(0).put(1).put(2).put(3).put(4).put(5).flip();
        this.coordinates.put(0.0f).put(1.0f);
        this.coordinates.put(0.0f).put(0.0f);
        this.coordinates.put(1.0f).put(0.0f);
        this.coordinates.put(0.0f).put(1.0f);
        this.coordinates.put(1.0f).put(0.0f);
        this.coordinates.put(1.0f).put(1.0f);
        this.coordinates.flip();
        this.updatePositions();
        this.gl = GL.getInstance();
        this.handle = this.gl.glGenVertexArrays();
        this.texHandle = this.gl.glGenTextures();
        this.bind();
        this.pHandle = this.gl.glGenBuffers();
        this.gl.glBindBuffer(34962, this.pHandle);
        this.gl.glBufferData(34962, this.positions, 35044);
        this.gl.glVertexAttribPointer(VertexBuffer.Type.Position.ordinal(), 4, Util.glFormat(VertexBuffer.Format.Float), false, 0, 0);
        this.iHandle = this.gl.glGenBuffers();
        this.gl.glBindBuffer(34963, this.iHandle);
        this.gl.glBufferData(34963, this.indices, 35044);
        this.uvHandle = this.gl.glGenBuffers();
        this.gl.glBindBuffer(34962, this.uvHandle);
        this.gl.glBufferData(34962, this.coordinates, 35044);
        this.gl.glVertexAttribPointer(VertexBuffer.Type.TexturCoordinate.ordinal(), 2, Util.glFormat(VertexBuffer.Format.Float), false, 0, 0);
        this.gl.glPixelStorei(3317, 1);
        this.gl.glTexImage2D(Util.glTexture(Texture.Type.Texture2D), 0, 32856, n3, n4, 0, Util.glPixelType(Texture.PixelType.RGBA), 5121, this.textureBuffer);
        this.unbind();
        this.sync = new Synchronizer();
        this.thread = new InternalRenderThread();
        this.thread.start();
    }

    @Override
    public void free() {
        this.thread.terminate();
    }

    protected void finalize() throws Throwable {
        this.free();
        super.finalize();
    }

    @Override
    public void bind() {
        this.gl.glBindVertexArray(this.handle);
        this.gl.glBindBuffer(34963, this.iHandle);
        this.gl.glBindTexture(Util.glTexture(Texture.Type.Texture2D), this.texHandle);
        this.gl.glActiveTexture(33984);
    }

    @Override
    public void unbind() {
        this.gl.glBindVertexArray(0);
        this.gl.glBindBuffer(34963, 0);
        this.gl.glBindTexture(Util.glTexture(Texture.Type.Texture2D), 0);
    }

    @Override
    public void enable() {
        this.gl.glEnableVertexAttribArray(VertexBuffer.Type.Position.ordinal());
        this.gl.glEnableVertexAttribArray(VertexBuffer.Type.TexturCoordinate.ordinal());
    }

    @Override
    public void disable() {
        this.gl.glDisableVertexAttribArray(VertexBuffer.Type.Position.ordinal());
        this.gl.glDisableVertexAttribArray(VertexBuffer.Type.TexturCoordinate.ordinal());
    }

    @Override
    public void select(int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repaint() {
        ByteBuffer byteBuffer = this.textureBuffer;
        synchronized (byteBuffer) {
            this.gl.glBindTexture(Util.glTexture(Texture.Type.Texture2D), this.texHandle);
            GL11.glTexSubImage2D((int)Util.glTexture(Texture.Type.Texture2D), (int)0, (int)0, (int)0, (int)this.width, (int)this.height, (int)Util.glPixelType(Texture.PixelType.RGBA), (int)5121, (ByteBuffer)this.textureBuffer);
            this.gl.glBindTexture(Util.glTexture(Texture.Type.Texture2D), 0);
        }
        this.sync.simplyNotify();
    }

    @Override
    public void paint(Graphics graphics) {
    }

    protected void updatePositions() {
        this.positions.clear();
        this.positions.put(this.x);
        this.positions.put(this.y);
        this.positions.put(this.z);
        this.positions.put(1.0f);
        this.positions.put(this.x);
        this.positions.put(this.y - this.height);
        this.positions.put(this.z);
        this.positions.put(1.0f);
        this.positions.put(this.x + this.width);
        this.positions.put(this.y - this.height);
        this.positions.put(this.z);
        this.positions.put(1.0f);
        this.positions.put(this.x);
        this.positions.put(this.y);
        this.positions.put(this.z);
        this.positions.put(1.0f);
        this.positions.put(this.x + this.width);
        this.positions.put(this.y - this.height);
        this.positions.put(this.z);
        this.positions.put(1.0f);
        this.positions.put(this.x + this.width);
        this.positions.put(this.y);
        this.positions.put(this.z);
        this.positions.put(1.0f);
        this.positions.flip();
    }

    private class InternalRenderThread
    extends Thread {
        private boolean isRunning;
        private ByteBuffer buffer;
        private int[] pixels;

        public InternalRenderThread() {
            super("NativeUI-Render-Thread");
            this.isRunning = false;
            this.buffer = ByteBuffer.allocateDirect(NativeUIFrameImpl.this.width * NativeUIFrameImpl.this.height * 4);
            this.pixels = new int[NativeUIFrameImpl.this.width * NativeUIFrameImpl.this.height];
        }

        public void terminate() {
            this.isRunning = false;
            NativeUIFrameImpl.this.sync.simplyNotify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.isRunning = true;
            while (this.isRunning) {
                int n;
                NativeUIFrameImpl.this.sync.simplyWait();
                if (!this.isRunning) break;
                NativeUIFrameImpl.this.textureImage = new BufferedImage(NativeUIFrameImpl.this.width, NativeUIFrameImpl.this.height, 2);
                Graphics2D graphics2D = (Graphics2D)NativeUIFrameImpl.this.textureImage.getGraphics();
                graphics2D.setColor(NativeUIFrameImpl.this.background);
                graphics2D.fillRect(0, 0, NativeUIFrameImpl.this.width, NativeUIFrameImpl.this.height);
                for (UIComponent uIComponent : NativeUIFrameImpl.this.components) {
                    n = uIComponent.getX();
                    int n2 = uIComponent.getY();
                    int n3 = uIComponent.getWidth();
                    int n4 = uIComponent.getHeight();
                    if (n < 0 || n2 < 0 || n3 <= 0 || n4 <= 0) break;
                    if (n + n3 > NativeUIFrameImpl.this.textureImage.getWidth()) {
                        n3 = NativeUIFrameImpl.this.textureImage.getWidth() - n;
                    }
                    if (n2 + n4 > NativeUIFrameImpl.this.textureImage.getHeight()) {
                        n4 = NativeUIFrameImpl.this.textureImage.getHeight() - n2;
                    }
                    uIComponent.paint(NativeUIFrameImpl.this.textureImage.getSubimage(n, n2, n3, n4).getGraphics());
                }
                NativeUIFrameImpl.this.textureImage.getRGB(0, 0, NativeUIFrameImpl.this.textureImage.getWidth(), NativeUIFrameImpl.this.textureImage.getHeight(), this.pixels, 0, NativeUIFrameImpl.this.textureImage.getWidth());
                this.buffer.clear();
                for (int i = NativeUIFrameImpl.this.textureImage.getHeight() - 1; i >= 0; --i) {
                    for (int j = 0; j < NativeUIFrameImpl.this.textureImage.getWidth(); ++j) {
                        n = this.pixels[i * NativeUIFrameImpl.this.textureImage.getWidth() + j];
                        this.buffer.put((byte)(n >> 16 & 0xFF));
                        this.buffer.put((byte)(n >> 8 & 0xFF));
                        this.buffer.put((byte)(n & 0xFF));
                        this.buffer.put((byte)(n >> 24 & 0xFF));
                    }
                }
                this.buffer.flip();
                ByteBuffer byteBuffer = NativeUIFrameImpl.this.textureBuffer;
                synchronized (byteBuffer) {
                    NativeUIFrameImpl.this.textureBuffer.clear();
                    NativeUIFrameImpl.this.textureBuffer.put(this.buffer);
                    NativeUIFrameImpl.this.textureBuffer.flip();
                }
            }
        }
    }
}

