/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.gfx.core.impl;

import de.ti2010.mars.assets.core.VertexBuffer;
import de.ti2010.mars.gfx.core.NativeVertexBuffer;
import de.ti2010.mars.gfx.gl.GL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

class NativeVertexBufferImpl
implements NativeVertexBuffer {
    private GL gl;
    private InternalNativeVertexBuffer origin;

    NativeVertexBufferImpl() {
    }

    @Override
    public void initialize(VertexBuffer.Format format, VertexBuffer.Type type, VertexBuffer.Usage usage, int n, Buffer buffer) {
        if (format == null || type == null || usage == null || buffer == null) {
            throw new IllegalArgumentException("Can not initialize a VertexBuffer when a argument is null!");
        }
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("The specified number of components has to be between 1 and 4!");
        }
        if (this.origin != null) {
            throw new RuntimeException("This VertexBuffer has been already initialized!");
        }
        switch (format) {
            case Byte: 
            case Short: {
                this.origin = new NativeShortVertexBuffer();
                break;
            }
            case Long: 
            case Double: {
                throw new UnsupportedOperationException("No implementation for a VertexBuffer with " + (Object)((Object)format) + "!");
            }
            case Integer: {
                this.origin = new NativeIntegerVertexBuffer();
                break;
            }
            case Float: {
                this.origin = new NativeFloatVertexBuffer();
            }
        }
        this.gl = GL.getInstance();
        this.origin.initialize(format, type, usage, n, buffer);
    }

    @Override
    public boolean isInitialized() {
        return this.origin != null && this.origin.isInitialized();
    }

    @Override
    public VertexBuffer.Format getFormat() {
        return this.origin.getFormat();
    }

    @Override
    public VertexBuffer.Type getType() {
        return this.origin.getType();
    }

    @Override
    public VertexBuffer.Usage getUsage() {
        return this.origin.getUsage();
    }

    @Override
    public void setUsage(VertexBuffer.Usage usage) {
        this.origin.setUsage(usage);
    }

    @Override
    public int getComponents() {
        return this.origin.getComponents();
    }

    @Override
    public int getElements() {
        return this.origin.getElements();
    }

    @Override
    public Buffer getData() {
        return this.origin.getData();
    }

    @Override
    public void free() {
        this.origin.free();
    }

    @Override
    public void bind() {
        this.origin.bind();
    }

    @Override
    public void unbind() {
        this.origin.unbind();
    }

    @Override
    public void buffer() {
        this.origin.buffer();
    }

    private static int glTarget(VertexBuffer.Type type) {
        switch (type) {
            case Position: {
                return 34962;
            }
            case VertexNormal: {
                return 34962;
            }
            case FaceNormal: {
                return 34962;
            }
            case Color: {
                return 34962;
            }
            case Index: {
                return 34963;
            }
            case TexturCoordinate: {
                return 34962;
            }
        }
        throw new IllegalArgumentException("No target defined!");
    }

    private class NativeFloatVertexBuffer
    extends InternalNativeVertexBuffer {
        private FloatBuffer data;

        private NativeFloatVertexBuffer() {
        }

        @Override
        public void initialize(VertexBuffer.Format format, VertexBuffer.Type type, VertexBuffer.Usage usage, int n, Buffer buffer) {
            super.initialize(format, type, usage, n, buffer);
            if (format != VertexBuffer.Format.Float) {
                throw new IllegalArgumentException("Unexpected VertexBuffer format: " + (Object)((Object)format) + "!");
            }
            this.data = ByteBuffer.allocateDirect(buffer.limit() * format.size).order(ByteOrder.nativeOrder()).asFloatBuffer();
            this.data.put((FloatBuffer)buffer);
            this.data.flip();
            buffer.rewind();
        }

        @Override
        public void buffer() {
            this.bind();
            NativeVertexBufferImpl.this.gl.glBufferData(NativeVertexBufferImpl.glTarget(this.type), this.data, this.usage());
            this.unbind();
        }

        @Override
        public int getElements() {
            return this.data.limit();
        }

        @Override
        public Buffer getData() {
            return this.data.asReadOnlyBuffer();
        }
    }

    private class NativeIntegerVertexBuffer
    extends InternalNativeVertexBuffer {
        private IntBuffer data;

        private NativeIntegerVertexBuffer() {
        }

        @Override
        public void initialize(VertexBuffer.Format format, VertexBuffer.Type type, VertexBuffer.Usage usage, int n, Buffer buffer) {
            super.initialize(format, type, usage, n, buffer);
            if (format != VertexBuffer.Format.Integer) {
                throw new IllegalArgumentException("Unexpected VertexBuffer format: " + (Object)((Object)format) + "!");
            }
            this.data = ByteBuffer.allocateDirect(buffer.limit() * format.size).order(ByteOrder.nativeOrder()).asIntBuffer();
            this.data.put((IntBuffer)buffer);
            this.data.flip();
            buffer.rewind();
        }

        @Override
        public void buffer() {
            this.bind();
            NativeVertexBufferImpl.this.gl.glBufferData(NativeVertexBufferImpl.glTarget(this.type), this.data, this.usage());
            this.unbind();
        }

        @Override
        public int getElements() {
            return this.data.limit();
        }

        @Override
        public Buffer getData() {
            return this.data.asReadOnlyBuffer();
        }
    }

    private class NativeShortVertexBuffer
    extends InternalNativeVertexBuffer {
        private ShortBuffer data;

        private NativeShortVertexBuffer() {
        }

        @Override
        public void initialize(VertexBuffer.Format format, VertexBuffer.Type type, VertexBuffer.Usage usage, int n, Buffer buffer) {
            super.initialize(format, type, usage, n, buffer);
            if (format != VertexBuffer.Format.Short) {
                throw new IllegalArgumentException("Unexpected VertexBuffer format: " + (Object)((Object)format) + "!");
            }
            this.data = ByteBuffer.allocateDirect(buffer.limit() * format.size).order(ByteOrder.nativeOrder()).asShortBuffer();
            this.data.put((ShortBuffer)buffer);
            this.data.flip();
            buffer.rewind();
        }

        @Override
        public void buffer() {
            this.bind();
            NativeVertexBufferImpl.this.gl.glBufferData(NativeVertexBufferImpl.glTarget(this.type), this.data, this.usage());
            this.unbind();
        }

        @Override
        public int getElements() {
            return this.data.limit();
        }

        @Override
        public Buffer getData() {
            return this.data.asReadOnlyBuffer();
        }
    }

    private abstract class InternalNativeVertexBuffer
    implements NativeVertexBuffer {
        protected int handle = -1;
        protected VertexBuffer.Format format;
        protected VertexBuffer.Type type;
        protected VertexBuffer.Usage usage;
        protected int components;

        private InternalNativeVertexBuffer() {
        }

        @Override
        public void initialize(VertexBuffer.Format format, VertexBuffer.Type type, VertexBuffer.Usage usage, int n, Buffer buffer) {
            if (this.handle != -1) {
                throw new RuntimeException("This VertexBuffer has been already initialized!");
            }
            this.format = format;
            this.type = type;
            this.usage = usage;
            this.components = n;
            this.handle = NativeVertexBufferImpl.this.gl.glGenBuffers();
        }

        @Override
        public boolean isInitialized() {
            return this.handle != -1;
        }

        @Override
        public VertexBuffer.Format getFormat() {
            return this.format;
        }

        @Override
        public VertexBuffer.Type getType() {
            return this.type;
        }

        @Override
        public VertexBuffer.Usage getUsage() {
            return this.usage;
        }

        @Override
        public void setUsage(VertexBuffer.Usage usage) {
            this.usage = usage;
        }

        @Override
        public int getComponents() {
            return this.components;
        }

        @Override
        public void bind() {
            NativeVertexBufferImpl.this.gl.glBindBuffer(NativeVertexBufferImpl.glTarget(this.type), this.handle);
        }

        @Override
        public void unbind() {
            NativeVertexBufferImpl.this.gl.glBindBuffer(NativeVertexBufferImpl.glTarget(this.type), 0);
        }

        @Override
        public void free() {
            NativeVertexBufferImpl.this.gl.glDeleteBuffers(this.handle);
        }

        protected void finalize() throws Throwable {
            this.free();
        }

        protected int usage() {
            switch (this.usage) {
                case Static: {
                    return 35044;
                }
                case Dynamic: {
                    return 35048;
                }
                case Stream: {
                    return 35040;
                }
            }
            return 35044;
        }
    }
}

