/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.gfx.renderer.impl;

import de.ti2010.mars.assets.core.VertexBuffer;
import de.ti2010.mars.gfx.Util;
import de.ti2010.mars.gfx.Vendor;
import de.ti2010.mars.gfx.core.NativeMesh;
import de.ti2010.mars.gfx.core.NativeObject;
import de.ti2010.mars.gfx.core.NativeTexture;
import de.ti2010.mars.gfx.core.NativeVertexBuffer;
import de.ti2010.mars.gfx.gl.GL;
import de.ti2010.mars.gfx.renderer.RenderConfiguration;
import de.ti2010.mars.gfx.renderer.SceneRenderer;
import de.ti2010.mars.gfx.shader.Program;
import de.ti2010.mars.gfx.shader.Shader;
import de.ti2010.mars.scene.GeometryNode;
import de.ti2010.mars.scene.LightNode;
import de.ti2010.mars.scene.Scene;
import de.ti2010.mars.scene.SceneGeometryIterator;
import de.ti2010.mars.scene.SceneLightIterator;
import de.ti2010.mars.scene.light.SpotLight;
import java.util.ArrayList;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

class SceneRendererImpl
implements SceneRenderer {
    private Vendor VendorID = Vendor.Unknown;
    private GL gl;
    private Program programForColoredRendering = null;
    private Program programForTexturedRendering = null;
    private RenderConfiguration configuration = null;
    private SceneRenderer.Mode mode = SceneRenderer.Mode.Fill;

    SceneRendererImpl() {
    }

    @Override
    public void initialize(RenderConfiguration renderConfiguration) {
        this.gl = GL.getInstance();
        if (this.gl.glGetString(7936).contains("ATI")) {
            this.VendorID = Vendor.ATI;
        } else if (this.gl.glGetString(7936).contains("NVIDIA")) {
            this.VendorID = Vendor.NVIDIA;
        }
        renderConfiguration.setVendor(this.VendorID);
        this.configuration = renderConfiguration;
        this.initializeProgramForColoredRendering();
        this.initializeProgramForTexturedRendering();
    }

    private void initializeProgramForColoredRendering() {
        this.programForColoredRendering = new Program();
        this.programForColoredRendering.initialize();
        Shader shader = new Shader();
        shader.initialize(Shader.Type.VertexShader, new Shader.Source(this.configuration.getPathOfVertexShaderColoredRendering()));
        Shader shader2 = new Shader();
        shader2.initialize(Shader.Type.FragmentShader, new Shader.Source(this.configuration.getPathOfFragmentShaderColoredRendering()));
        this.programForColoredRendering.attach(shader);
        this.programForColoredRendering.attach(shader2);
        this.programForColoredRendering.link();
        this.programForColoredRendering.use();
        this.programForColoredRendering.getUniformMatrix4f("projectionMatrix").get().setIdentity();
        this.programForColoredRendering.getUniformMatrix4f((String)"projectionMatrix").get().m00 = this.configuration.getXScale();
        this.programForColoredRendering.getUniformMatrix4f((String)"projectionMatrix").get().m11 = this.configuration.getYScale();
        this.programForColoredRendering.getUniformMatrix4f((String)"projectionMatrix").get().m22 = -((this.configuration.getFarPlane() + this.configuration.getNearPlane()) / this.configuration.getFrustumLength());
        this.programForColoredRendering.getUniformMatrix4f((String)"projectionMatrix").get().m23 = -1.0f;
        this.programForColoredRendering.getUniformMatrix4f((String)"projectionMatrix").get().m32 = -(2.0f * this.configuration.getNearPlane() * this.configuration.getFarPlane() / this.configuration.getFrustumLength());
        this.programForColoredRendering.getUniformMatrix4f("projectionMatrix").push();
    }

    private void initializeProgramForTexturedRendering() {
        this.programForTexturedRendering = new Program();
        this.programForTexturedRendering.initialize();
        Shader shader = new Shader();
        shader.initialize(Shader.Type.VertexShader, new Shader.Source(this.configuration.getPathOfVertexShaderTexturedRendering()));
        Shader shader2 = new Shader();
        shader2.initialize(Shader.Type.FragmentShader, new Shader.Source(this.configuration.getPathOfFragmentShaderTexturedRendering()));
        this.programForTexturedRendering.attach(shader);
        this.programForTexturedRendering.attach(shader2);
        this.programForTexturedRendering.link();
        this.programForTexturedRendering.use();
        this.programForTexturedRendering.getUniformMatrix4f("projectionMatrix").get().setIdentity();
        this.programForTexturedRendering.getUniformMatrix4f((String)"projectionMatrix").get().m00 = this.configuration.getXScale();
        this.programForTexturedRendering.getUniformMatrix4f((String)"projectionMatrix").get().m11 = this.configuration.getYScale();
        this.programForTexturedRendering.getUniformMatrix4f((String)"projectionMatrix").get().m22 = -((this.configuration.getFarPlane() + this.configuration.getNearPlane()) / this.configuration.getFrustumLength());
        this.programForTexturedRendering.getUniformMatrix4f((String)"projectionMatrix").get().m23 = -1.0f;
        this.programForTexturedRendering.getUniformMatrix4f((String)"projectionMatrix").get().m32 = -(2.0f * this.configuration.getNearPlane() * this.configuration.getFarPlane() / this.configuration.getFrustumLength());
        this.programForTexturedRendering.getUniformMatrix4f("projectionMatrix").push();
    }

    @Override
    public SceneRenderer.Mode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(SceneRenderer.Mode mode) {
        if (this.mode != mode) {
            switch (mode) {
                case Point: {
                    this.gl.glPolygonMode(1032, 6912);
                    this.gl.glDisable(2884);
                    break;
                }
                case Line: {
                    this.gl.glPolygonMode(1032, 6913);
                    this.gl.glDisable(2884);
                    break;
                }
                default: {
                    this.gl.glPolygonMode(1032, 6914);
                    this.gl.glEnable(2884);
                }
            }
            this.mode = mode;
        }
    }

    @Override
    public void render(Scene scene) {
        if (scene == null) {
            return;
        }
        SceneGeometryIterator sceneGeometryIterator = scene.geometries();
        SceneLightIterator sceneLightIterator = scene.lights();
        this.gl.glClear(16640);
        Matrix4f matrix4f = scene.getCamera().getViewMatrix();
        ArrayList<LightNode> arrayList = new ArrayList<LightNode>();
        while (sceneLightIterator.hasNext()) {
            arrayList.add(sceneLightIterator.next());
        }
        while (sceneGeometryIterator.hasNext()) {
            NativeObject nativeObject;
            GeometryNode geometryNode = sceneGeometryIterator.next();
            if (geometryNode.getTexture() == null) {
                this.programForColoredRendering.use();
                this.programForColoredRendering.getUniformMatrix4f("modelMatrix").get().set(geometryNode.getCumulateMatrix());
                this.programForColoredRendering.getUniformMatrix4f("modelMatrix").push();
                this.programForColoredRendering.getUniformMatrix4f("viewMatrix").get().set(matrix4f);
                this.programForColoredRendering.getUniformMatrix4f("viewMatrix").push();
            } else {
                this.programForTexturedRendering.use();
                nativeObject = (NativeTexture)geometryNode.getTexture();
                nativeObject.select(33984);
                nativeObject.bind();
                this.gl.glGenerateMipmap(Util.glTexture(nativeObject.getType()));
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.programForTexturedRendering.use();
                    Vector3f vector3f = new Vector3f();
                    if (arrayList.get(i) instanceof SpotLight) {
                        SpotLight spotLight = (SpotLight)arrayList.get(i);
                        spotLight.getAbsoluteTranslation().get(vector3f);
                        Vector3f vector3f2 = new Vector3f(1.0f, 0.0f, 1.0f);
                        Matrix4f matrix4f2 = new Matrix4f();
                        matrix4f2.setIdentity();
                        matrix4f2.rotY((float)Math.toRadians(-45.0));
                        matrix4f2.mul(spotLight.getAbsoluteRotation());
                        matrix4f2.transform(vector3f2);
                        vector3f2.y = 0.3f;
                        this.programForTexturedRendering.getUniform3f("spot_Direction").get().set((Tuple3f)vector3f2);
                        this.programForTexturedRendering.getUniform3f("spot_Direction").push();
                        this.programForTexturedRendering.getUniform4f("spot_Position").get().set((Tuple3f)vector3f);
                        this.programForTexturedRendering.getUniform4f("spot_Position").push();
                        this.programForTexturedRendering.getUniform4f("light_Diffuse").get().set((Tuple4f)spotLight.getDiffuse());
                        this.programForTexturedRendering.getUniform4f("light_Diffuse").push();
                        this.programForTexturedRendering.getUniform4f("light_Ambient").get().set((Tuple4f)spotLight.getAmbient());
                        this.programForTexturedRendering.getUniform4f("light_Ambient").push();
                        this.programForTexturedRendering.getUniform1f("spot_Intensity").set(spotLight.getIntensity());
                        this.programForTexturedRendering.getUniform1f("spot_Intensity").push();
                        this.programForTexturedRendering.getUniform1f("spot_Cutoff").set(spotLight.getSpotCutoff());
                        this.programForTexturedRendering.getUniform1f("spot_Cutoff").push();
                        this.programForTexturedRendering.getUniform1f("spot_Exponent").set(spotLight.getSpotExponent());
                        this.programForTexturedRendering.getUniform1f("spot_Exponent").push();
                        this.programForTexturedRendering.getUniform1f("constAtt").set(spotLight.getConstantAttenuation());
                        this.programForTexturedRendering.getUniform1f("constAtt").push();
                        this.programForTexturedRendering.getUniform1f("lineaAtt").set(spotLight.getLinearAttenuation());
                        this.programForTexturedRendering.getUniform1f("lineaAtt").push();
                        this.programForTexturedRendering.getUniform1f("quadAtt").set(spotLight.getQuadraticAttenuation());
                        this.programForTexturedRendering.getUniform1f("quadAtt").push();
                    } else {
                        ((LightNode)arrayList.get(i)).getAbsoluteTranslation().get(vector3f);
                        this.programForTexturedRendering.getUniform4f("light_Position").get().set((Tuple3f)vector3f);
                        this.programForTexturedRendering.getUniform4f("light_Position").push();
                        this.programForTexturedRendering.getUniform4f("light_Diffuse").get().set(((LightNode)arrayList.get((int)i)).getDiffuse().x, ((LightNode)arrayList.get((int)i)).getDiffuse().y, ((LightNode)arrayList.get((int)i)).getDiffuse().z, ((LightNode)arrayList.get((int)i)).getDiffuse().w);
                        this.programForTexturedRendering.getUniform4f("light_Diffuse").push();
                        this.programForTexturedRendering.getUniform4f("light_Ambient").get().set(((LightNode)arrayList.get((int)i)).getAmbient().x, ((LightNode)arrayList.get((int)i)).getAmbient().y, ((LightNode)arrayList.get((int)i)).getAmbient().z, ((LightNode)arrayList.get((int)i)).getAmbient().w);
                        this.programForTexturedRendering.getUniform4f("light_Ambient").push();
                    }
                    this.programForTexturedRendering.getUniformMatrix4f("modelMatrix").get().set(((LightNode)arrayList.get(i)).getCumulateMatrix());
                    this.programForTexturedRendering.getUniformMatrix4f("modelMatrix").push();
                    this.programForTexturedRendering.getUniformMatrix4f("viewMatrix").get().set(matrix4f);
                    this.programForTexturedRendering.getUniformMatrix4f("viewMatrix").push();
                }
                this.programForTexturedRendering.getUniformMatrix4f("modelMatrix").get().set(geometryNode.getCumulateMatrix());
                this.programForTexturedRendering.getUniformMatrix4f("modelMatrix").push();
                this.programForTexturedRendering.getUniformMatrix4f("viewMatrix").get().set(matrix4f);
                this.programForTexturedRendering.getUniformMatrix4f("viewMatrix").push();
            }
            nativeObject = (NativeMesh)geometryNode.getMesh();
            this.renderMesh((NativeMesh)nativeObject);
        }
        this.exitOnGLError("Error after rendering!");
    }

    public void exitOnGLError(String string) {
        int n = GL11.glGetError();
        if (n != 0) {
            String string2 = GLU.gluErrorString((int)n);
            System.err.println("ERROR - " + string + ": " + string2);
            if (Display.isCreated()) {
                Display.destroy();
            }
            System.exit(-1);
        }
    }

    private void renderMesh(NativeMesh nativeMesh) {
        nativeMesh.bind();
        nativeMesh.enable();
        NativeVertexBuffer nativeVertexBuffer = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Index);
        nativeVertexBuffer.bind();
        this.gl.glDrawElements(Util.glMode(nativeMesh.getMode()), nativeVertexBuffer.getElements(), 5125, 0L);
        nativeVertexBuffer.unbind();
        nativeMesh.disable();
        nativeMesh.unbind();
        this.exitOnGLError("Error in loopScene");
    }
}

