/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.gfx.shader;

import de.ti2010.mars.gfx.core.NativeObject;
import de.ti2010.mars.gfx.gl.GL;
import de.ti2010.mars.gfx.shader.ProgramException;
import de.ti2010.mars.gfx.shader.ShaderException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class Shader
implements NativeObject {
    private GL gl;
    int handle = -1;
    private boolean isInitialized = false;
    private Type type;

    public void initialize(Type type, Source source) throws ShaderException {
        if (this.isInitialized()) {
            throw new ProgramException("Shader has already been initialized!");
        }
        this.gl = GL.getInstance();
        try {
            if (type == null) {
                throw new ShaderException("Can not initialize shader with null type!");
            }
            this.type = type;
            try {
                this.handle = this.gl.glCreateShader(type.glType);
            }
            catch (Exception exception) {
                throw new ShaderException("Shader creation failed!", exception);
            }
            try {
                this.gl.glShaderSource(this.handle, source.load());
            }
            catch (Exception exception) {
                throw new ShaderException("Shader source code loading failed!", exception);
            }
            try {
                this.gl.glCompileShader(this.handle);
            }
            catch (Exception exception) {
                throw new ShaderException("Error during compilation!", exception);
            }
            if (this.gl.glGetShader(this.handle, 35713) == 0) {
                String string = this.gl.glGetShaderInfoLog(this.handle, 1337);
                throw new ShaderException("Compilation of " + (Object)((Object)type) + " failed: " + string);
            }
            this.isInitialized = true;
        }
        catch (Exception exception) {
            throw new ShaderException("Initialization of shader failed!", exception);
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public void free() {
        throw new UnsupportedOperationException("Shader.free()");
    }

    public boolean equals(Object object) {
        if (object instanceof Shader) {
            Shader shader = (Shader)object;
            return shader.handle == this.handle;
        }
        return false;
    }

    public static class Source {
        private File file;

        public Source(String string) {
            this(new File(string));
        }

        public Source(File file) {
            this.file = file;
        }

        ByteBuffer load() throws IOException {
            if (!this.file.exists()) {
                throw new ShaderException("The specifed file doesn't exist: " + this.file.getAbsolutePath());
            }
            if (this.file.isDirectory()) {
                throw new ShaderException("The specifed path doesn't point to a file: " + this.file.getAbsolutePath());
            }
            if (this.file.length() > Integer.MAX_VALUE) {
                throw new ShaderException("The specified file is too large: " + this.file.getAbsolutePath());
            }
            FileInputStream fileInputStream = new FileInputStream(this.file);
            FileChannel fileChannel = fileInputStream.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect((int)this.file.length()).order(ByteOrder.nativeOrder());
            fileChannel.read(byteBuffer);
            byteBuffer.flip();
            fileInputStream.close();
            return byteBuffer;
        }
    }

    public static enum Type {
        VertexShader(35633),
        GeometryShader(36313),
        FragmentShader(35632);

        final int glType;

        private Type(int n2) {
            this.glType = n2;
        }
    }
}

