/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.gfx.shader;

import de.ti2010.mars.gfx.shader.Program;
import de.ti2010.mars.gfx.shader.Uniform;
import de.ti2010.mars.gfx.shader.UniformException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class Uniform1f
extends Uniform<Uniform1f> {
    private float value;
    private FloatBuffer data;

    Uniform1f(int n, String string, Program program) {
        super(n, string, program);
        try {
            this.data = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
        catch (Exception exception) {
            throw new UniformException("Instantiation of the uniform failed!", exception);
        }
    }

    @Override
    public Uniform1f fetch() {
        this.data.clear();
        this.gl.glGetUniform(this.program.handle, this.handle, this.data);
        if (this.gl.glGetError() != 0) {
            throw new UniformException("Fetching the uniform failed!");
        }
        this.data.flip();
        this.value = this.data.get();
        return this;
    }

    @Override
    public Uniform1f push() {
        this.data.clear();
        this.data.put(this.value);
        this.data.flip();
        this.gl.glUniform1(this.handle, this.data);
        if (this.gl.glGetError() != 0) {
            throw new UniformException("Pushing the uniform failed!");
        }
        return this;
    }

    public float get() {
        return this.value;
    }

    public void set(float f) {
        this.value = f;
    }
}

