/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.gfx.shader;

import de.ti2010.mars.gfx.shader.Program;
import de.ti2010.mars.gfx.shader.Uniform;
import de.ti2010.mars.gfx.shader.UniformException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import javax.vecmath.Matrix4f;

public class UniformMatrix4f
extends Uniform<UniformMatrix4f> {
    private Matrix4f matrix;
    private FloatBuffer data;

    UniformMatrix4f(int n, String string, Program program) {
        super(n, string, program);
        try {
            this.matrix = new Matrix4f();
            this.matrix.setIdentity();
            this.data = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
        catch (UniformException uniformException) {
            throw new UniformException("Instantiation of the uniform failed!", uniformException);
        }
    }

    @Override
    public UniformMatrix4f fetch() throws UniformException {
        this.data.clear();
        this.gl.glGetUniform(this.program.handle, this.handle, this.data);
        if (this.gl.glGetError() != 0) {
            throw new UniformException("Fetching the uniform failed!");
        }
        this.data.flip();
        this.matrix.m00 = this.data.get();
        this.matrix.m01 = this.data.get();
        this.matrix.m02 = this.data.get();
        this.matrix.m03 = this.data.get();
        this.matrix.m10 = this.data.get();
        this.matrix.m11 = this.data.get();
        this.matrix.m12 = this.data.get();
        this.matrix.m13 = this.data.get();
        this.matrix.m20 = this.data.get();
        this.matrix.m21 = this.data.get();
        this.matrix.m22 = this.data.get();
        this.matrix.m23 = this.data.get();
        this.matrix.m30 = this.data.get();
        this.matrix.m31 = this.data.get();
        this.matrix.m32 = this.data.get();
        this.matrix.m33 = this.data.get();
        return this;
    }

    @Override
    public UniformMatrix4f push() throws UniformException {
        this.data.put(this.matrix.m00).put(this.matrix.m01).put(this.matrix.m02).put(this.matrix.m03);
        this.data.put(this.matrix.m10).put(this.matrix.m11).put(this.matrix.m12).put(this.matrix.m13);
        this.data.put(this.matrix.m20).put(this.matrix.m21).put(this.matrix.m22).put(this.matrix.m23);
        this.data.put(this.matrix.m30).put(this.matrix.m31).put(this.matrix.m32).put(this.matrix.m33);
        this.data.flip();
        this.gl.glUniformMatrix4(this.handle, true, this.data);
        if (this.gl.glGetError() != 0) {
            throw new UniformException("Pushing the uniform failed!");
        }
        return this;
    }

    public Matrix4f get() {
        return this.matrix;
    }

    public String toString() {
        return this.matrix.toString();
    }
}

