/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.io;

import de.ti2010.mars.io.SourceException;
import de.ti2010.mars.io.blender.BlenderSource;
import de.ti2010.mars.io.png.PNGFileSource;
import java.net.URI;

public abstract class Source {
    protected String name;
    protected URI uri;

    protected Source(String string, URI uRI) {
        this.name = string;
        this.uri = uRI;
    }

    public abstract Source open() throws SourceException;

    public abstract void close() throws SourceException;

    public abstract Type getType();

    public abstract boolean isOpen();

    public boolean isClosed() {
        return !this.isOpen();
    }

    public static Source create(String string, URI uRI, Type type) {
        return type.create(string, uRI);
    }

    public static Source open(String string, URI uRI, Type type) {
        return type.create(string, uRI).open();
    }

    public static enum Type {
        BlenderFile{

            @Override
            Source create(String string, URI uRI) {
                return new BlenderSource(string, uRI);
            }
        }
        ,
        PNGFile{

            @Override
            Source create(String string, URI uRI) {
                return new PNGFileSource(string, uRI);
            }
        };


        Source create(String string, URI uRI) {
            return null;
        }
    }
}

