/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.io.blender.impl;

import de.ti2010.mars.io.blender.BlenderFileBlock;
import de.ti2010.mars.io.blender.BlenderFileBlockView;
import de.ti2010.mars.io.blender.BlenderFileException;
import de.ti2010.mars.io.blender.impl.BlenderFileImpl;
import java.nio.ByteBuffer;

class BlenderFileBlockImpl
implements BlenderFileBlock {
    public static final int HEADER_SIZE_IN_BYTE = 12;
    private BlenderFileImpl blenderFile;
    private String identifier;
    private int startOffset;
    private int size;
    private long oldMemoryAddress;
    private int sdnaIndex;
    private int structCount;

    public BlenderFileBlockImpl(BlenderFileImpl blenderFileImpl) {
        this.blenderFile = blenderFileImpl;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(int n) {
        this.startOffset = n;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    @Override
    public long getAddress() {
        return this.oldMemoryAddress;
    }

    public void setAddress(long l) {
        this.oldMemoryAddress = l;
    }

    public int getSdnaIndex() {
        return this.sdnaIndex;
    }

    public void setSdnaIndex(int n) {
        this.sdnaIndex = n;
    }

    public int getStructCount() {
        return this.structCount;
    }

    public void setStructCount(int n) {
        this.structCount = n;
    }

    public void initialize(ByteBuffer byteBuffer) throws BlenderFileException {
        this.parseStartOffset(byteBuffer);
        this.parseName(byteBuffer);
        this.parseSize(byteBuffer);
        this.parseOldMemmoryAddress(byteBuffer);
        this.parseSdnaIndex(byteBuffer);
        this.parseStructCount(byteBuffer);
        byteBuffer.position(byteBuffer.position() + this.getSize());
    }

    private void parseStartOffset(ByteBuffer byteBuffer) {
        this.setStartOffset(byteBuffer.position());
    }

    private void parseName(ByteBuffer byteBuffer) {
        String string = "";
        for (int i = 0; i < 4; ++i) {
            string = string + String.valueOf((char)byteBuffer.get());
        }
        this.identifier = string;
    }

    private void parseSize(ByteBuffer byteBuffer) {
        this.setSize(byteBuffer.getInt());
    }

    private void parseOldMemmoryAddress(ByteBuffer byteBuffer) throws BlenderFileException {
        int n = this.blenderFile.getHeader().getPointerSize();
        long l = 0L;
        if (n == 4) {
            l = byteBuffer.getInt();
        } else if (n == 8) {
            l = byteBuffer.getLong();
        } else {
            throw new BlenderFileException("Pointersize ist not set");
        }
        this.setAddress(l);
    }

    private void parseSdnaIndex(ByteBuffer byteBuffer) {
        this.setSdnaIndex(byteBuffer.getInt());
    }

    private void parseStructCount(ByteBuffer byteBuffer) {
        this.setStructCount(byteBuffer.getInt());
    }

    @Override
    public BlenderFileBlockView view() {
        return new View();
    }

    public String toString() {
        return this.identifier;
    }

    private class View
    implements BlenderFileBlockView {
        private ByteBuffer buffer;
        private int pos = 0;

        public View() {
            this.buffer = BlenderFileBlockImpl.this.blenderFile.getBuffer();
        }

        @Override
        public BlenderFileBlockView position(int n) {
            this.pos = n;
            return this;
        }

        @Override
        public int position() {
            return this.pos;
        }

        @Override
        public BlenderFileBlockView rewind() {
            this.pos = 0;
            return this;
        }

        @Override
        public byte get() {
            byte by = this.buffer.get(this.offset());
            ++this.pos;
            return by;
        }

        @Override
        public char getChar() {
            char c = this.buffer.getChar(this.offset());
            ++this.pos;
            return c;
        }

        @Override
        public short getShort() {
            short s = this.buffer.getShort(this.offset());
            this.pos += 2;
            return s;
        }

        @Override
        public int getInt() {
            int n = this.buffer.getInt(this.offset());
            this.pos += 4;
            return n;
        }

        @Override
        public float getFloat() {
            float f = this.buffer.getFloat(this.offset());
            this.pos += 4;
            return f;
        }

        @Override
        public double getDouble() {
            double d = this.buffer.getDouble(this.offset());
            this.pos += 8;
            return d;
        }

        @Override
        public long getLong() {
            long l = this.buffer.getLong(this.offset());
            this.pos += 8;
            return l;
        }

        private int offset() {
            return BlenderFileBlockImpl.this.startOffset + 16 + BlenderFileBlockImpl.this.blenderFile.getHeader().getPointerSize() + this.pos;
        }

        @Override
        public long getAddress() {
            long l = 0L;
            l = BlenderFileBlockImpl.this.blenderFile.getHeader().getPointerSize() > 4 ? this.getLong() : (long)this.getInt();
            return l;
        }
    }
}

