/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.io.blender.impl;

import de.ti2010.mars.io.blender.BlenderFileBlock;
import de.ti2010.mars.io.blender.BlenderFileBlockView;
import de.ti2010.mars.io.blender.BlenderFileCatalogue;
import de.ti2010.mars.io.blender.BlenderFileException;
import de.ti2010.mars.io.blender.impl.BlenderFileImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="catalogue")
@XmlAccessorType(value=XmlAccessType.NONE)
class BlenderFileCatalogueImpl
implements BlenderFileCatalogue {
    private BlenderFileImpl blenderFile;
    private List<Type> types;
    @XmlElement(name="structure", required=true)
    private List<Struct> structs;

    public BlenderFileCatalogueImpl() {
    }

    public BlenderFileCatalogueImpl(BlenderFileImpl blenderFileImpl) {
        this.blenderFile = blenderFileImpl;
    }

    public void initialize(BlenderFileBlock blenderFileBlock) {
        int n;
        if (!blenderFileBlock.getIdentifier().equals("DNA1")) {
            throw new BlenderFileException();
        }
        BlenderFileBlockView blenderFileBlockView = blenderFileBlock.view();
        StringBuilder stringBuilder = new StringBuilder();
        blenderFileBlockView.position(8);
        String[] stringArray = new String[blenderFileBlockView.getInt()];
        char c = '\u0000';
        for (n = 0; n < stringArray.length; ++n) {
            do {
                c = (char)blenderFileBlockView.get();
                stringBuilder.append(c);
            } while (c != '\u0000');
            stringArray[n] = stringBuilder.toString().trim();
            stringBuilder = new StringBuilder();
        }
        blenderFileBlockView.position(blenderFileBlockView.position() + 3);
        stringBuilder = new StringBuilder();
        for (n = 0; n < 4; ++n) {
            stringBuilder.append((char)blenderFileBlockView.get());
        }
        String[] stringArray2 = new String[blenderFileBlockView.getInt()];
        stringBuilder = new StringBuilder();
        c = '\u0000';
        for (n = 0; n < stringArray2.length; ++n) {
            do {
                c = (char)blenderFileBlockView.get();
                stringBuilder.append(c);
            } while (c != '\u0000');
            stringArray2[n] = stringBuilder.toString().trim();
            stringBuilder = new StringBuilder();
        }
        stringBuilder = new StringBuilder();
        for (n = 0; n < 4; ++n) {
            stringBuilder.append((char)blenderFileBlockView.get());
        }
        int[] nArray = new int[stringArray2.length];
        for (n = 0; n < stringArray2.length; ++n) {
            nArray[n] = blenderFileBlockView.getShort();
        }
        stringBuilder = new StringBuilder();
        for (n = 0; n < 4; ++n) {
            stringBuilder.append((char)blenderFileBlockView.get());
        }
        this.types = new ArrayList<Type>(stringArray2.length);
        for (n = 0; n < stringArray2.length; ++n) {
            this.types.add(new Type(stringArray2[n], nArray[n], this.blenderFile.getHeader().getPointerSize()));
        }
        n = blenderFileBlockView.getInt();
        this.structs = new ArrayList<Struct>(n);
        for (int i = 0; i < n; ++i) {
            Type type = this.types.get(blenderFileBlockView.getShort());
            int n2 = blenderFileBlockView.getShort();
            Struct struct = new Struct(n2);
            struct.setType(type);
            for (int j = 0; j < n2; ++j) {
                type = this.types.get(blenderFileBlockView.getShort());
                String string = stringArray[blenderFileBlockView.getShort()];
                Type type2 = new Type(string, type.getSize(), this.blenderFile.getHeader().getPointerSize());
                struct.addComponent(new Component(type2.getName(), type2));
            }
            this.structs.add(struct);
        }
    }

    @Override
    public BlenderFileCatalogue.Struct getStructByName(String string) {
        for (Struct struct : this.structs) {
            if (!struct.getName().equalsIgnoreCase(string)) continue;
            return struct;
        }
        return null;
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlType(propOrder={"size", "offset", "name"})
    private static class Component {
        private String name;
        private Type type;
        private int offset = -1;

        public Component() {
            this("", null);
        }

        public Component(String string, Type type) {
            this.name = string;
            this.type = type;
        }

        @XmlAttribute(name="reference")
        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        @XmlAttribute
        public int getSize() {
            return this.type.getSize();
        }

        @XmlAttribute
        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int n) {
            this.offset = n;
        }

        public String toString() {
            return this.name + "\t" + this.type;
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    private static class Type {
        protected Type origin;
        protected int pointerSize = 4;

        protected Type() {
        }

        public Type(String string, int n, int n2) {
            this.origin = new Base(string, n, n2);
            this.pointerSize = n2;
            if (string.charAt(0) == '*') {
                this.origin = new Pointer(this.origin);
                if (string.charAt(1) == '*') {
                    this.origin = new Pointer(this.origin);
                }
            }
            int n3 = string.indexOf(91);
            int n4 = string.indexOf(93);
            if (n3 > -1 && n4 > -1) {
                int n5 = Integer.valueOf(string.substring(n3 + 1, n4));
                this.origin = new Array(this.origin, n5);
            }
        }

        public String getName() {
            return this.origin.getName();
        }

        public int getSize() {
            return this.origin.getSize();
        }

        public boolean isPointer() {
            return false;
        }

        public boolean isArray() {
            return false;
        }

        public String toString() {
            return this.origin.toString();
        }

        private static class Array
        extends Type {
            private int length = 0;

            public Array(Type type, int n) {
                this.length = n;
                this.origin = type;
                this.pointerSize = type.pointerSize;
            }

            @Override
            public String getName() {
                int n = super.getName().indexOf(91);
                return super.getName().substring(0, n);
            }

            @Override
            public int getSize() {
                return super.getSize() * this.length;
            }

            @Override
            public boolean isArray() {
                return true;
            }

            @Override
            public String toString() {
                return "arr_" + this.getName() + "\t" + String.valueOf(this.getSize());
            }
        }

        private static class Pointer
        extends Type {
            public Pointer(Type type) {
                this.origin = type;
                this.pointerSize = type.pointerSize;
            }

            @Override
            public String getName() {
                return super.getName().substring(1);
            }

            @Override
            public int getSize() {
                return this.pointerSize;
            }

            @Override
            public boolean isPointer() {
                return true;
            }

            @Override
            public String toString() {
                return "ptr_" + this.getName() + "\t" + String.valueOf(this.getSize());
            }
        }

        private static class Base
        extends Type {
            private String name;
            private int size;

            public Base(String string, int n, int n2) {
                this.name = string;
                this.size = n;
                this.pointerSize = n2;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public int getSize() {
                return this.size;
            }

            @Override
            public String toString() {
                return this.getName() + "\t" + String.valueOf(this.getSize());
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlType(propOrder={"size", "name", "components"})
    public static class Struct
    implements BlenderFileCatalogue.Struct {
        private Type type;
        @XmlElement(name="component")
        private List<Component> components;

        public Struct() {
            this(0);
        }

        public Struct(int n) {
            this.components = new ArrayList<Component>(n);
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        @Override
        @XmlAttribute
        public String getName() {
            return this.type.getName();
        }

        @Override
        @XmlAttribute
        public int size() {
            int n = 0;
            for (Component component : this.components) {
                n += component.getSize();
            }
            return n;
        }

        public void addComponent(Component component) {
            int n = 0;
            for (Component component2 : this.components) {
                if (component2 == null) continue;
                n += component2.getSize();
            }
            component.setOffset(n);
            this.components.add(component);
        }

        public Component getComponent(int n) {
            return this.components.get(n);
        }

        @Override
        public int offset(String string) {
            Component component;
            int n = 0;
            boolean bl = false;
            Iterator<Component> iterator = this.components.iterator();
            while (iterator.hasNext() && !(bl = (component = iterator.next()).getName().equalsIgnoreCase(string))) {
                n += component.getSize();
            }
            return bl ? n : -1;
        }

        public String toString() {
            return this.type.getName() + "\t" + String.valueOf(this.size());
        }
    }
}

