/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.io.blender.impl;

import de.ti2010.mars.io.blender.BlenderFileException;
import de.ti2010.mars.io.blender.BlenderFileHeader;
import java.nio.ByteBuffer;

class BlenderFileHeaderImpl
implements BlenderFileHeader {
    private ByteBuffer headBuffer;
    private String identifier;
    private int pointerSize;
    private boolean littleEndianness;
    private String versionNumber;

    public void initialize(ByteBuffer byteBuffer) throws BlenderFileException {
        this.headBuffer = ByteBuffer.allocate(12);
        for (int i = 0; i < this.headBuffer.capacity(); ++i) {
            this.headBuffer.put(byteBuffer.get());
        }
        this.headBuffer.flip();
        this.checkFile(this.headBuffer);
        this.parsePointerSize(this.headBuffer);
        this.parseEndianness(this.headBuffer);
        this.parseVersion(this.headBuffer);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String string) {
        this.identifier = string;
    }

    @Override
    public int getPointerSize() {
        return this.pointerSize;
    }

    public void setPointerSize(int n) {
        this.pointerSize = n;
    }

    @Override
    public boolean isLittleEndian() {
        return this.littleEndianness;
    }

    public void setLittleEndianness(boolean bl) {
        this.littleEndianness = bl;
    }

    @Override
    public String getVersion() {
        return this.versionNumber;
    }

    public void setVersionNumber(String string) {
        this.versionNumber = string;
    }

    private void checkFile(ByteBuffer byteBuffer) throws BlenderFileException {
        this.identifier = "";
        for (int i = 0; i < 7; ++i) {
            this.identifier = this.identifier + String.valueOf((char)byteBuffer.get());
        }
        if (!this.identifier.equals("BLENDER")) {
            throw new BlenderFileException("File corrupt");
        }
    }

    private void parsePointerSize(ByteBuffer byteBuffer) throws BlenderFileException {
        char c = (char)byteBuffer.get();
        if (c == '_') {
            this.setPointerSize(4);
        } else if (c == '-') {
            this.setPointerSize(8);
        } else {
            throw new BlenderFileException("Illegal pointersize");
        }
    }

    private void parseEndianness(ByteBuffer byteBuffer) throws BlenderFileException {
        char c = (char)byteBuffer.get();
        if (c == 'v') {
            this.setLittleEndianness(true);
        } else if (c == 'V') {
            this.setLittleEndianness(false);
        } else {
            throw new BlenderFileException("Illegal endianness");
        }
    }

    private void parseVersion(ByteBuffer byteBuffer) {
        this.setVersionNumber(String.valueOf((char)byteBuffer.get()) + "." + String.valueOf((char)byteBuffer.get()) + String.valueOf((char)byteBuffer.get()));
    }

    public void print() {
        System.out.println("Header:");
        System.out.println("\tVersion: \t\t" + this.getVersion());
        System.out.println("\tLittle Endianness: \t" + this.isLittleEndian());
        System.out.println("\tPointersize: \t\t" + this.getPointerSize());
    }
}

