/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.physics.jbullet;

import com.bulletphysics.collision.shapes.BoxShape;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.collision.shapes.CompoundShape;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.RigidBodyConstructionInfo;
import com.bulletphysics.dynamics.vehicle.DefaultVehicleRaycaster;
import com.bulletphysics.dynamics.vehicle.RaycastVehicle;
import com.bulletphysics.dynamics.vehicle.VehicleRaycaster;
import com.bulletphysics.dynamics.vehicle.VehicleTuning;
import com.bulletphysics.dynamics.vehicle.WheelInfo;
import com.bulletphysics.linearmath.DefaultMotionState;
import com.bulletphysics.linearmath.MotionState;
import com.bulletphysics.linearmath.Transform;
import de.ti2010.mars.physics.jbullet.JBulletWorld;
import de.ti2010.mars.simulator.PhysicsEntity;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;

public abstract class JBulletAbstractRaycastVehicleElementRepresentation {
    protected PhysicsEntity physicsEntity = null;
    protected Transform tempTransBody = new Transform();
    protected Transform tempTransWheel1 = new Transform();
    protected Transform tempTransWheel2 = new Transform();
    protected Transform tempTransWheel3 = new Transform();
    protected Transform tempTransWheel4 = new Transform();
    protected Transform tempTransWheel5 = new Transform();
    protected Transform tempTransWheel6 = new Transform();
    protected final int rightIndex = 0;
    protected final int upIndex = 1;
    protected final int forwardIndex = 2;
    protected final Vector3f wheelDirectionCS0 = new Vector3f(0.0f, -1.0f, 0.0f);
    protected final Vector3f wheelAxleCS = new Vector3f(-1.0f, 0.0f, 0.0f);
    protected float gEngineForce = 0.0f;
    protected float gBreakingForce = 0.0f;
    protected float maxEngineForce = 500.0f;
    protected float maxBreakingForce = 100.0f;
    protected float gVehicleSteering = 0.0f;
    protected float steeringIncrement = 0.005f;
    protected float steeringClamp = 0.3f;
    protected float wheelRadius = 0.5f;
    protected float wheelWidth = 0.5f;
    protected float wheelFriction = 1000.0f;
    protected float suspensionStiffness = 60.0f;
    protected float suspensionDamping = 2.3f;
    protected float suspensionCompression = 4.4f;
    protected float rollInfluence = 0.1f;
    protected final float suspensionRestLength = 0.4f;
    protected final int CUBE_HALF_EXTENTS = 1;
    protected RigidBody carChassis = null;
    protected VehicleTuning tuning = new VehicleTuning();
    protected VehicleRaycaster vehicleRayCaster = null;
    protected RaycastVehicle vehicle = null;
    protected Transform tr = new Transform();
    protected CollisionShape chassisShape = new BoxShape(new Vector3f(2.0f, 2.0f, 2.0f));
    protected Transform localTrans = new Transform();
    protected CompoundShape compound = new CompoundShape();
    protected Vector3f inertia = new Vector3f(0.0f, 0.0f, 0.0f);
    protected float mass = 2000.0f;
    protected MotionState ms = new DefaultMotionState();
    protected Transform tra = new Transform();
    protected Vector3f forwardVector = new Vector3f();

    public JBulletAbstractRaycastVehicleElementRepresentation(PhysicsEntity physicsEntity) {
        this.physicsEntity = physicsEntity;
        this.tr.setIdentity();
        this.tr.origin.set(0.0f, -4.5f, 0.0f);
        this.chassisShape.setUserPointer("Warning");
        this.localTrans.setIdentity();
        this.localTrans.origin.set(0.0f, 1.0f, 0.0f);
        this.compound.addChildShape(this.localTrans, this.chassisShape);
        this.tr.origin.set(0.0f, 0.0f, 0.0f);
        this.ms.setWorldTransform(this.tr);
        this.compound.calculateLocalInertia(this.mass, this.inertia);
        RigidBodyConstructionInfo rigidBodyConstructionInfo = new RigidBodyConstructionInfo(this.mass, this.ms, this.compound, this.inertia);
        this.carChassis = new RigidBody(rigidBodyConstructionInfo);
        this.gVehicleSteering = 0.0f;
        this.tra.setIdentity();
        this.carChassis.setCenterOfMassTransform(this.tra);
        this.carChassis.setLinearVelocity(new Vector3f(0.0f, 0.0f, 0.0f));
        this.carChassis.setAngularVelocity(new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public void initializeAfterBuilt(JBulletWorld jBulletWorld) {
        jBulletWorld.getDynamicsWorld().addRigidBody(this.carChassis);
        jBulletWorld.getDynamicsWorld().getBroadphase().getOverlappingPairCache().cleanProxyFromPairs(this.carChassis.getBroadphaseHandle(), jBulletWorld.getDynamicsWorld().getDispatcher());
        if (this.vehicle != null) {
            this.vehicle.resetSuspension();
            for (int i = 0; i < this.vehicle.getNumWheels(); ++i) {
                this.vehicle.updateWheelTransform(i, true);
            }
        }
        this.vehicleRayCaster = new DefaultVehicleRaycaster(jBulletWorld.getDynamicsWorld());
        this.vehicle = new RaycastVehicle(this.tuning, this.carChassis, this.vehicleRayCaster);
        this.carChassis.setActivationState(4);
        jBulletWorld.getDynamicsWorld().addVehicle(this.vehicle);
        float f = -0.3f;
        this.vehicle.setCoordinateSystem(0, 1, 2);
        boolean bl = true;
        Vector3f vector3f = new Vector3f(1.5f, f, 1.6f);
        this.vehicle.addWheel(vector3f, this.wheelDirectionCS0, this.wheelAxleCS, 0.4f, this.wheelRadius, this.tuning, bl);
        Vector3f vector3f2 = new Vector3f(-1.5f, f, 1.6f);
        this.vehicle.addWheel(vector3f2, this.wheelDirectionCS0, this.wheelAxleCS, 0.4f, this.wheelRadius, this.tuning, bl);
        Vector3f vector3f3 = new Vector3f(1.5f, f, -1.8f);
        this.vehicle.addWheel(vector3f3, this.wheelDirectionCS0, this.wheelAxleCS, 0.4f, this.wheelRadius, this.tuning, bl);
        Vector3f vector3f4 = new Vector3f(-1.5f, f, -1.8f);
        this.vehicle.addWheel(vector3f4, this.wheelDirectionCS0, this.wheelAxleCS, 0.4f, this.wheelRadius, this.tuning, bl);
        bl = false;
        Vector3f vector3f5 = new Vector3f(1.5f, f, -0.1f);
        this.vehicle.addWheel(vector3f5, this.wheelDirectionCS0, this.wheelAxleCS, 0.4f, this.wheelRadius, this.tuning, bl);
        Vector3f vector3f6 = new Vector3f(-1.5f, f, -0.1f);
        this.vehicle.addWheel(vector3f6, this.wheelDirectionCS0, this.wheelAxleCS, 0.4f, this.wheelRadius, this.tuning, bl);
        for (int i = 0; i < this.vehicle.getNumWheels(); ++i) {
            WheelInfo wheelInfo = this.vehicle.getWheelInfo(i);
            wheelInfo.suspensionStiffness = this.suspensionStiffness;
            wheelInfo.wheelsDampingRelaxation = this.suspensionDamping;
            wheelInfo.wheelsDampingCompression = this.suspensionCompression;
            wheelInfo.frictionSlip = this.wheelFriction;
            wheelInfo.rollInfluence = this.rollInfluence;
        }
    }

    public void notifyChanged() {
        System.out.println("Nicht aufrufbar!!!!!!11111111111elf");
    }

    public Matrix3f getRotationMatrixBody() {
        this.vehicle.getChassisWorldTransform(this.tempTransBody);
        return this.tempTransBody.basis;
    }

    public Vector3f getTranslationMatrixBody() {
        this.vehicle.getChassisWorldTransform(this.tempTransBody);
        return this.tempTransBody.origin;
    }

    public Matrix3f getRotationMatrixWheel1() {
        this.vehicle.updateWheelTransform(0, true);
        this.tempTransWheel1 = this.vehicle.getWheelInfo((int)0).worldTransform;
        return this.tempTransWheel1.basis;
    }

    public Vector3f getTranslationMatrixWheel1() {
        this.vehicle.updateWheelTransform(0, true);
        this.tempTransWheel1 = this.vehicle.getWheelInfo((int)0).worldTransform;
        return this.tempTransWheel1.origin;
    }

    public Matrix3f getRotationMatrixWheel2() {
        this.vehicle.updateWheelTransform(1, true);
        this.tempTransWheel2 = this.vehicle.getWheelInfo((int)1).worldTransform;
        return this.tempTransWheel2.basis;
    }

    public Vector3f getTranslationMatrixWheel2() {
        this.vehicle.updateWheelTransform(1, true);
        this.tempTransWheel2 = this.vehicle.getWheelInfo((int)1).worldTransform;
        return this.tempTransWheel2.origin;
    }

    public Matrix3f getRotationMatrixWheel3() {
        this.vehicle.updateWheelTransform(2, true);
        this.tempTransWheel3 = this.vehicle.getWheelInfo((int)2).worldTransform;
        return this.tempTransWheel3.basis;
    }

    public Vector3f getTranslationMatrixWheel3() {
        this.vehicle.updateWheelTransform(2, true);
        this.tempTransWheel3 = this.vehicle.getWheelInfo((int)2).worldTransform;
        return this.tempTransWheel3.origin;
    }

    public Matrix3f getRotationMatrixWheel4() {
        this.vehicle.updateWheelTransform(3, true);
        this.tempTransWheel4 = this.vehicle.getWheelInfo((int)3).worldTransform;
        return this.tempTransWheel4.basis;
    }

    public Vector3f getTranslationMatrixWheel4() {
        this.vehicle.updateWheelTransform(3, true);
        this.tempTransWheel4 = this.vehicle.getWheelInfo((int)3).worldTransform;
        return this.tempTransWheel4.origin;
    }

    public Matrix3f getRotationMatrixWheel5() {
        this.vehicle.updateWheelTransform(4, true);
        this.tempTransWheel5 = this.vehicle.getWheelInfo((int)4).worldTransform;
        return this.tempTransWheel5.basis;
    }

    public Vector3f getTranslationMatrixWheel5() {
        this.vehicle.updateWheelTransform(4, true);
        this.tempTransWheel5 = this.vehicle.getWheelInfo((int)4).worldTransform;
        return this.tempTransWheel5.origin;
    }

    public Matrix3f getRotationMatrixWheel6() {
        this.vehicle.updateWheelTransform(5, true);
        this.tempTransWheel6 = this.vehicle.getWheelInfo((int)5).worldTransform;
        return this.tempTransWheel6.basis;
    }

    public Vector3f getTranslationMatrixWheel6() {
        this.vehicle.updateWheelTransform(5, true);
        this.tempTransWheel6 = this.vehicle.getWheelInfo((int)5).worldTransform;
        return this.tempTransWheel6.origin;
    }

    public void applyEngineForce(float f, int n) {
        this.vehicle.applyEngineForce(f, n);
    }

    public void setBrake(float f, int n) {
        this.vehicle.setBrake(f, n);
    }

    public void setSteeringValueForWholeRover(float f) {
        this.gVehicleSteering = f;
        this.setSteeringValueForWheel(f, 0);
        this.setSteeringValueForWheel(f, 1);
        this.setSteeringValueForWheel(-f, 2);
        this.setSteeringValueForWheel(-f, 3);
    }

    public void setSteeringValueForWheel(float f, int n) {
        this.vehicle.setSteeringValue(f, n);
    }

    public float getVehicleSteering() {
        return this.gVehicleSteering;
    }

    public float getSteeringIncrement() {
        return this.steeringIncrement;
    }

    public float getSteeringClamp() {
        return this.steeringClamp;
    }

    public float getWheelRadius() {
        return this.wheelRadius;
    }

    public float getWheelWidth() {
        return this.wheelWidth;
    }

    public float getWheelFriction() {
        return this.wheelFriction;
    }

    public float getSuspensionStiffness() {
        return this.suspensionStiffness;
    }

    public float getSuspensionDamping() {
        return this.suspensionDamping;
    }

    public float getSuspensionCompression() {
        return this.suspensionCompression;
    }

    public float getRollInfluence() {
        return this.rollInfluence;
    }

    public float getEngineForce() {
        return this.gEngineForce;
    }

    public float getBreakingForce() {
        return this.gBreakingForce;
    }

    public float getMaxEngineForce() {
        return this.maxEngineForce;
    }

    public float getMaxBreakingForce() {
        return this.maxBreakingForce;
    }

    public Vector3f getForwardVector() {
        this.vehicle.getForwardVector(this.forwardVector);
        return this.forwardVector;
    }

    public float getCurrentSpeedKmHour() {
        return this.vehicle.getCurrentSpeedKmHour();
    }

    public void setPosition(Vector3f vector3f) {
        Transform transform = new Transform();
        transform.setIdentity();
        transform.origin.x = vector3f.x;
        transform.origin.y = vector3f.y;
        transform.origin.z = vector3f.z;
        this.carChassis.setWorldTransform(transform);
        this.carChassis.clearForces();
    }
}

