/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.physics.jbullet;

import com.bulletphysics.collision.broadphase.BroadphaseInterface;
import com.bulletphysics.collision.broadphase.DbvtBroadphase;
import com.bulletphysics.collision.dispatch.CollisionConfiguration;
import com.bulletphysics.collision.dispatch.CollisionDispatcher;
import com.bulletphysics.collision.dispatch.DefaultCollisionConfiguration;
import com.bulletphysics.collision.shapes.BoxShape;
import com.bulletphysics.dynamics.DiscreteDynamicsWorld;
import com.bulletphysics.dynamics.DynamicsWorld;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.RigidBodyConstructionInfo;
import com.bulletphysics.dynamics.constraintsolver.ConstraintSolver;
import com.bulletphysics.dynamics.constraintsolver.SequentialImpulseConstraintSolver;
import com.bulletphysics.linearmath.DefaultMotionState;
import com.bulletphysics.linearmath.MotionState;
import com.bulletphysics.linearmath.Transform;
import de.ti2010.mars.physics.jbullet.JBulletAbstractBasicElementRepresentation;
import de.ti2010.mars.physics.jbullet.JBulletAbstractRaycastVehicleElementRepresentation;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;

public class JBulletWorld {
    private BroadphaseInterface broadphaseInterface = null;
    private CollisionConfiguration collisionConfiguration = null;
    private CollisionDispatcher collisionDispatcher = null;
    private ConstraintSolver constraintSolver = null;
    private DiscreteDynamicsWorld dynamicsWorld = null;
    private Vector3f gravity = new Vector3f(0.0f, -10.0f, 0.0f);
    private List<JBulletAbstractBasicElementRepresentation> jBulletAbstractBasicElementRepresentationList = null;
    private List<JBulletAbstractRaycastVehicleElementRepresentation> jBulletAbstractRaycastVehicleElementRepresentationList = null;

    public JBulletWorld() {
        this.broadphaseInterface = new DbvtBroadphase();
        this.collisionConfiguration = new DefaultCollisionConfiguration();
        this.collisionDispatcher = new CollisionDispatcher(this.collisionConfiguration);
        this.constraintSolver = new SequentialImpulseConstraintSolver();
        this.dynamicsWorld = new DiscreteDynamicsWorld(this.collisionDispatcher, this.broadphaseInterface, this.constraintSolver, this.collisionConfiguration);
        this.dynamicsWorld.setGravity(this.gravity);
        this.jBulletAbstractBasicElementRepresentationList = new ArrayList<JBulletAbstractBasicElementRepresentation>();
        this.jBulletAbstractRaycastVehicleElementRepresentationList = new ArrayList<JBulletAbstractRaycastVehicleElementRepresentation>();
        float f = 0.0f;
        DefaultMotionState defaultMotionState = new DefaultMotionState();
        DefaultMotionState defaultMotionState2 = new DefaultMotionState();
        DefaultMotionState defaultMotionState3 = new DefaultMotionState();
        DefaultMotionState defaultMotionState4 = new DefaultMotionState();
        DefaultMotionState defaultMotionState5 = new DefaultMotionState();
        DefaultMotionState defaultMotionState6 = new DefaultMotionState();
        BoxShape boxShape = new BoxShape(new Vector3f(500.0f, 10.0f, 1.0f));
        BoxShape boxShape2 = new BoxShape(new Vector3f(1.0f, 10.0f, 500.0f));
        Transform transform = new Transform();
        Quat4f quat4f = new Quat4f();
        Vector3f vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
        AxisAngle4f axisAngle4f = new AxisAngle4f(vector3f, (float)Math.toRadians(-50.0));
        quat4f.normalize();
        quat4f.set(axisAngle4f);
        ((MotionState)defaultMotionState).getWorldTransform(transform);
        transform.origin.z = 255.0f;
        ((MotionState)defaultMotionState).setWorldTransform(transform);
        RigidBodyConstructionInfo rigidBodyConstructionInfo = new RigidBodyConstructionInfo(f, defaultMotionState, boxShape);
        RigidBody rigidBody = new RigidBody(rigidBodyConstructionInfo);
        ((MotionState)defaultMotionState2).getWorldTransform(transform);
        transform.origin.z = -245.0f;
        ((MotionState)defaultMotionState2).setWorldTransform(transform);
        RigidBodyConstructionInfo rigidBodyConstructionInfo2 = new RigidBodyConstructionInfo(f, defaultMotionState2, boxShape);
        RigidBody rigidBody2 = new RigidBody(rigidBodyConstructionInfo2);
        ((MotionState)defaultMotionState3).getWorldTransform(transform);
        transform.origin.x = 350.0f;
        ((MotionState)defaultMotionState3).setWorldTransform(transform);
        RigidBodyConstructionInfo rigidBodyConstructionInfo3 = new RigidBodyConstructionInfo(f, defaultMotionState3, boxShape2);
        RigidBody rigidBody3 = new RigidBody(rigidBodyConstructionInfo3);
        ((MotionState)defaultMotionState4).getWorldTransform(transform);
        transform.origin.x = -360.0f;
        ((MotionState)defaultMotionState4).setWorldTransform(transform);
        RigidBodyConstructionInfo rigidBodyConstructionInfo4 = new RigidBodyConstructionInfo(f, defaultMotionState4, boxShape2);
        RigidBody rigidBody4 = new RigidBody(rigidBodyConstructionInfo4);
        ((MotionState)defaultMotionState5).getWorldTransform(transform);
        transform.origin.x = -195.0f;
        transform.origin.z = -188.0f;
        transform.setRotation(quat4f);
        ((MotionState)defaultMotionState5).setWorldTransform(transform);
        RigidBodyConstructionInfo rigidBodyConstructionInfo5 = new RigidBodyConstructionInfo(f, defaultMotionState5, boxShape2);
        RigidBody rigidBody5 = new RigidBody(rigidBodyConstructionInfo5);
        ((MotionState)defaultMotionState6).getWorldTransform(transform);
        transform.origin.x = 200.0f;
        transform.origin.z = -195.0f;
        quat4f.inverse();
        transform.setRotation(quat4f);
        ((MotionState)defaultMotionState6).setWorldTransform(transform);
        RigidBodyConstructionInfo rigidBodyConstructionInfo6 = new RigidBodyConstructionInfo(f, defaultMotionState6, boxShape2);
        RigidBody rigidBody6 = new RigidBody(rigidBodyConstructionInfo6);
        this.dynamicsWorld.addRigidBody(rigidBody);
        this.dynamicsWorld.addRigidBody(rigidBody2);
        this.dynamicsWorld.addRigidBody(rigidBody3);
        this.dynamicsWorld.addRigidBody(rigidBody4);
        this.dynamicsWorld.addRigidBody(rigidBody5);
        this.dynamicsWorld.addRigidBody(rigidBody6);
    }

    public void doStep() {
        this.dynamicsWorld.stepSimulation(0.016666668f, 10);
        for (JBulletAbstractBasicElementRepresentation object : this.jBulletAbstractBasicElementRepresentationList) {
            object.notifyChanged();
        }
        for (JBulletAbstractRaycastVehicleElementRepresentation jBulletAbstractRaycastVehicleElementRepresentation : this.jBulletAbstractRaycastVehicleElementRepresentationList) {
            jBulletAbstractRaycastVehicleElementRepresentation.notifyChanged();
        }
    }

    public void setGravity(Vector3f vector3f) {
        this.gravity = vector3f;
    }

    public DynamicsWorld getDynamicsWorld() {
        return this.dynamicsWorld;
    }

    public void addJBulletAbstractBasicElementRepresentation(JBulletAbstractBasicElementRepresentation jBulletAbstractBasicElementRepresentation) {
        this.jBulletAbstractBasicElementRepresentationList.add(jBulletAbstractBasicElementRepresentation);
        this.dynamicsWorld.addRigidBody(jBulletAbstractBasicElementRepresentation.getRigidBody());
    }

    public void addJBulletAbstractRaycastVehicleElementRepresentation(JBulletAbstractRaycastVehicleElementRepresentation jBulletAbstractRaycastVehicleElementRepresentation) {
        this.jBulletAbstractRaycastVehicleElementRepresentationList.add(jBulletAbstractRaycastVehicleElementRepresentation);
    }
}

