/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.simulator;

import de.ti2010.mars.assets.core.Mesh;
import de.ti2010.mars.assets.core.VertexBuffer;
import de.ti2010.mars.assets.io.AssetLoader;
import de.ti2010.mars.assets.io.MeshDescriptor;
import de.ti2010.mars.assets.io.TextureDescriptor;
import de.ti2010.mars.gfx.core.NativeMesh;
import de.ti2010.mars.gfx.core.NativeTexture;
import de.ti2010.mars.gfx.core.NativeVertexBuffer;
import de.ti2010.mars.gfx.core.impl.NativeObjectFactory;
import de.ti2010.mars.io.Source;
import de.ti2010.mars.physics.core.AbstractElementFactory;
import de.ti2010.mars.physics.core.GroundElement;
import de.ti2010.mars.physics.core.WorldElement;
import de.ti2010.mars.scene.GeometryNode;
import de.ti2010.mars.scene.GroupNode;
import de.ti2010.mars.scene.Node;
import de.ti2010.mars.simulator.PhysicsEntity;
import de.ti2010.mars.simulator.WaterVein;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.vecmath.Vector3f;

public class Ground
implements PhysicsEntity {
    private String filepath = "/res/models/map/landscape_plane.blend";
    private GroupNode landscapenode;
    private Node groundNode;
    private Node eeNode;
    private GroundElement gge;
    private IntBuffer indicesBuffer = null;
    private FloatBuffer positionVerticesBuffer = null;
    private final int numberOfWater = 15;
    private WaterVein[] waterVeins = new WaterVein[15];
    private int foundWaterVeins = 0;

    public Ground() {
        for (int i = 0; i < 15; ++i) {
            WaterVein waterVein;
            this.waterVeins[i] = waterVein = new WaterVein();
        }
    }

    public Node buildGround() {
        this.landscapenode = new GroupNode();
        this.buildMesh();
        this.buildTexture();
        this.buildPhysicsElement();
        return this.landscapenode;
    }

    private void buildMesh() {
        this.groundNode = new GeometryNode("Ground");
        Source source = null;
        try {
            source = Source.open("", new URI("file:///" + System.getProperty("user.dir").replaceAll("\\\\", "/") + this.filepath), Source.Type.BlenderFile);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        NativeMesh nativeMesh = (NativeMesh)NativeObjectFactory.getInstance().createMesh();
        MeshDescriptor meshDescriptor = (MeshDescriptor)nativeMesh.getDescriptor();
        meshDescriptor.setSource(source);
        meshDescriptor.setName("landscape");
        meshDescriptor.setMode(Mesh.Mode.Triangles);
        AssetLoader assetLoader = AssetLoader.getInstance();
        assetLoader.load(nativeMesh);
        nativeMesh.bind();
        NativeVertexBuffer nativeVertexBuffer = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Position);
        nativeVertexBuffer.buffer();
        this.positionVerticesBuffer = (FloatBuffer)nativeVertexBuffer.getData();
        FloatBuffer floatBuffer = ByteBuffer.allocate(nativeVertexBuffer.getElements() << 2).asFloatBuffer();
        while (floatBuffer.position() < floatBuffer.capacity()) {
            floatBuffer.put(0.2f);
            floatBuffer.put(0.2f);
            floatBuffer.put(0.2f);
            floatBuffer.put(1.0f);
        }
        floatBuffer.flip();
        NativeVertexBuffer nativeVertexBuffer2 = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Color);
        nativeVertexBuffer2.initialize(VertexBuffer.Format.Float, VertexBuffer.Type.Color, VertexBuffer.Usage.Static, 4, floatBuffer);
        nativeVertexBuffer2.buffer();
        NativeVertexBuffer nativeVertexBuffer3 = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Index);
        nativeVertexBuffer3.buffer();
        this.indicesBuffer = (IntBuffer)nativeVertexBuffer3.getData();
        NativeVertexBuffer nativeVertexBuffer4 = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.TexturCoordinate);
        nativeVertexBuffer4.buffer();
        nativeMesh.unbind();
        ((GeometryNode)this.groundNode).setMesh(nativeMesh);
        this.buildEasterEgg();
        this.landscapenode.add(this.groundNode);
    }

    private void buildTexture() {
        NativeTexture nativeTexture = (NativeTexture)NativeObjectFactory.getInstance().createTexture();
        TextureDescriptor textureDescriptor = (TextureDescriptor)nativeTexture.getDescriptor();
        textureDescriptor.setName("ntex");
        try {
            textureDescriptor.setSource(Source.open("", new URI("file:///" + System.getProperty("user.dir").replaceAll("\\\\", "/") + "/res/textures/texture_ground.png"), Source.Type.PNGFile));
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        AssetLoader.getInstance().load(nativeTexture);
        nativeTexture.bind();
        nativeTexture.buffer();
        ((GeometryNode)this.groundNode).setTexture(nativeTexture);
    }

    private void buildPhysicsElement() {
        this.gge = AbstractElementFactory.getInstance().createGenericGroundElement(this);
    }

    @Override
    public void updateChanged() {
    }

    @Override
    public WorldElement getPhysicalElement() {
        return this.gge;
    }

    @Override
    public FloatBuffer getVertexPositions() {
        return this.positionVerticesBuffer;
    }

    @Override
    public IntBuffer getVertexPositionIndices() {
        return this.indicesBuffer;
    }

    public void setPosition(Vector3f vector3f) {
        this.gge.setPosition(vector3f);
    }

    public void checkDrillPostition(Vector3f vector3f) {
        if (vector3f == null) {
            return;
        }
        for (WaterVein waterVein : this.waterVeins) {
            if (!waterVein.checkPosition(vector3f)) continue;
            ++this.foundWaterVeins;
            return;
        }
    }

    public int getFoundWaterVeins() {
        return this.foundWaterVeins;
    }

    public int getNumberOfWater() {
        return 15;
    }

    private void buildEasterEgg() {
        this.eeNode = new GeometryNode();
        Source source = null;
        try {
            source = Source.open("", new URI("file:///" + System.getProperty("user.dir").replaceAll("\\\\", "/") + this.filepath), Source.Type.BlenderFile);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        NativeMesh nativeMesh = (NativeMesh)NativeObjectFactory.getInstance().createMesh();
        MeshDescriptor meshDescriptor = (MeshDescriptor)nativeMesh.getDescriptor();
        meshDescriptor.setSource(source);
        meshDescriptor.setName("easteregg");
        meshDescriptor.setMode(Mesh.Mode.Triangles);
        AssetLoader assetLoader = AssetLoader.getInstance();
        assetLoader.load(nativeMesh);
        nativeMesh.bind();
        NativeVertexBuffer nativeVertexBuffer = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Position);
        nativeVertexBuffer.buffer();
        this.positionVerticesBuffer = (FloatBuffer)nativeVertexBuffer.getData();
        FloatBuffer floatBuffer = ByteBuffer.allocate(nativeVertexBuffer.getElements() << 2).asFloatBuffer();
        while (floatBuffer.position() < floatBuffer.capacity()) {
            floatBuffer.put(0.2f);
            floatBuffer.put(0.2f);
            floatBuffer.put(0.2f);
            floatBuffer.put(1.0f);
        }
        floatBuffer.flip();
        NativeVertexBuffer nativeVertexBuffer2 = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Color);
        nativeVertexBuffer2.initialize(VertexBuffer.Format.Float, VertexBuffer.Type.Color, VertexBuffer.Usage.Static, 4, floatBuffer);
        nativeVertexBuffer2.buffer();
        NativeVertexBuffer nativeVertexBuffer3 = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Index);
        nativeVertexBuffer3.buffer();
        this.indicesBuffer = (IntBuffer)nativeVertexBuffer3.getData();
        NativeVertexBuffer nativeVertexBuffer4 = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.TexturCoordinate);
        nativeVertexBuffer4.buffer();
        nativeMesh.unbind();
        ((GeometryNode)this.eeNode).setMesh(nativeMesh);
        this.buildEETexture();
        this.eeNode.setRelativeTranslation(new Vector3f(345.0f, 2.0f, 345.0f));
        this.landscapenode.add(this.eeNode);
    }

    private void buildEETexture() {
        NativeTexture nativeTexture = (NativeTexture)NativeObjectFactory.getInstance().createTexture();
        TextureDescriptor textureDescriptor = (TextureDescriptor)nativeTexture.getDescriptor();
        textureDescriptor.setName("ntex");
        try {
            textureDescriptor.setSource(Source.open("", new URI("file:///" + System.getProperty("user.dir").replaceAll("\\\\", "/") + "/res/textures/easteregg.png"), Source.Type.PNGFile));
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        AssetLoader.getInstance().load(nativeTexture);
        nativeTexture.bind();
        nativeTexture.buffer();
        ((GeometryNode)this.eeNode).setTexture(nativeTexture);
    }
}

