/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.simulator;

import de.ti2010.mars.input.KeyEvent;
import de.ti2010.mars.input.MouseEvent;
import de.ti2010.mars.scene.Camera;
import de.ti2010.mars.simulator.Controller;

public class MenuController
implements Controller {
    private Camera camera = null;

    public MenuController(Camera camera) {
        this.camera = camera;
        this.initCamera();
    }

    private void initCamera() {
        this.camera.setMinPitch(0.2f);
        this.camera.setMaxPitch(0.6f);
        this.camera.setYaw(0.0f);
        this.camera.setPitch(0.4f);
        this.camera.setMinDistance(12.0f);
        this.camera.setMaxDistance(20.0f);
        this.camera.setDistance(15.0f);
        this.camera.setMouseSensitivity(1.0E-4f);
        this.camera.setDistanceChange(1.01f);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void handle(MouseEvent mouseEvent) {
        this.calculateYaw((float)mouseEvent.getDeltaX() * this.camera.getMouseSensitivity());
        this.calculatePitch((float)(-mouseEvent.getDeltaY()) * this.camera.getMouseSensitivity());
        if (mouseEvent.getDWheel() > 0) {
            this.camera.increaseDistance();
        }
        if (mouseEvent.getDWheel() < 0) {
            this.camera.decreaseDistance();
        }
    }

    @Override
    public void update() {
        this.calculateYaw(-0.005f);
    }

    private void calculateYaw(float f) {
        this.camera.setYaw(this.camera.getYaw() + f);
    }

    private void calculatePitch(float f) {
        this.camera.setPitch(this.camera.getPitch() + f);
    }

    @Override
    public void setCameraActive() {
        this.camera.setActive(true);
    }
}

