/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.simulator;

import de.ti2010.mars.assets.core.Asset;
import de.ti2010.mars.assets.core.Composite;
import de.ti2010.mars.assets.core.Mesh;
import de.ti2010.mars.assets.core.Texture;
import de.ti2010.mars.assets.core.VertexBuffer;
import de.ti2010.mars.assets.io.AssetLoader;
import de.ti2010.mars.assets.io.MeshDescriptor;
import de.ti2010.mars.assets.io.TextureDescriptor;
import de.ti2010.mars.gfx.core.NativeMesh;
import de.ti2010.mars.gfx.core.NativeTexture;
import de.ti2010.mars.gfx.core.NativeVertexBuffer;
import de.ti2010.mars.gfx.core.impl.NativeObjectFactory;
import de.ti2010.mars.input.KeyEvent;
import de.ti2010.mars.input.MouseEvent;
import de.ti2010.mars.io.Source;
import de.ti2010.mars.physics.core.AbstractElementFactory;
import de.ti2010.mars.physics.core.RoverElement;
import de.ti2010.mars.physics.core.WorldElement;
import de.ti2010.mars.physics.jbullet.JBulletAbstractRaycastVehicleElementRepresentation;
import de.ti2010.mars.physics.jbullet.JBulletWorld;
import de.ti2010.mars.scene.Camera;
import de.ti2010.mars.scene.GeometryNode;
import de.ti2010.mars.scene.GroupNode;
import de.ti2010.mars.scene.Node;
import de.ti2010.mars.simulator.Controller;
import de.ti2010.mars.simulator.PhysicsEntity;
import de.ti2010.mars.simulator.assets.Flashlight;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;

public class RoverVehicle
implements PhysicsEntity,
Controller {
    private Composite roverTextures = new Composite("Textures");
    private Node roverLight = null;
    private Flashlight flashlight = null;
    private boolean fl_status = false;
    private boolean startDrill = false;
    private int drillStep = -1;
    private Vector3f lastDrillPosition = null;
    private Node roverParentNode = new GroupNode("roverParentNode");
    private Node roverNodeBody = new GroupNode("roverNodeBody");
    private GeometryNode roverNodeAkku = new GeometryNode("roverNodeAkku");
    private GeometryNode roverNodeAkku_Aufbau = new GeometryNode("roverNodeAkku_Aufbau");
    private GeometryNode roverNodeFahrwerk = new GeometryNode("roverNodeFahrwerk");
    private GeometryNode roverNodeFischaugen = new GeometryNode("roverNodeFischaugen");
    private GeometryNode roverNodeKabel = new GeometryNode("roverNodeKabel");
    private GeometryNode roverNodeKameras = new GeometryNode("roverNodeKameras");
    private GeometryNode roverNodeMast_Halterung = new GeometryNode("roverNodeMast_Halterung");
    private GeometryNode roverNodeMast_Kopf = new GeometryNode("roverNodeMast_Kopf");
    private GeometryNode roverNodeMast_Kopf_Linsen = new GeometryNode("roverNodeMast_Kopf_Linsen");
    private GeometryNode roverNodeNaben = new GeometryNode("roverNodeNaben");
    private GeometryNode roverNodeRadaufhaengungen = new GeometryNode("roverNodeRadaufhaengungen");
    private GeometryNode roverNodeRover = new GeometryNode("roverNodeRover");
    private GeometryNode roverNodeScheinwerfer = new GeometryNode("roverNodeScheinwerfer");
    private GeometryNode roverNodeSchild = new GeometryNode("roverNodeSchild");
    private GeometryNode roverNodeSchrauben = new GeometryNode("roverNodeSchrauben");
    private GeometryNode roverNodeSolarzelle = new GeometryNode("roverNodeSolarzelle");
    private GeometryNode roverNodeWheel1 = new GeometryNode("roverNodeWheel1");
    private GeometryNode roverNodeWheel2 = new GeometryNode("roverNodeWheel2");
    private GeometryNode roverNodeWheel3 = new GeometryNode("roverNodeWheel3");
    private GeometryNode roverNodeWheel4 = new GeometryNode("roverNodeWheel4");
    private GeometryNode roverNodeWheel5 = new GeometryNode("roverNodeWheel5");
    private GeometryNode roverNodeWheel6 = new GeometryNode("roverNodeWheel6");
    private Node roverNodeClamshellFirstPartRotations = new GroupNode("roverNodeClamshellFirstPartRotations");
    private Node roverNodeClamshellFirstPartTranslations = new GroupNode("roverNodeClamshellFirstPartTranslations");
    private GeometryNode roverNodeClamshellFirstPartGeometry = new GeometryNode("roverNodeClamshellFirstPartGeometry");
    private Node roverNodeClamshellSecondPartRotations = new GroupNode("roverNodeClamshellSecondPartRotations");
    private Node roverNodeClamshellSecondPartTranslations = new GroupNode("roverNodeClamshellSecondPartTranslations");
    private GeometryNode roverNodeClamshellSecondPartGeometry = new GeometryNode("roverNodeClamshellSecondPartGeometry");
    private RoverElement gre = null;
    private Camera aktiveCamera;
    private Camera frontCamera;
    private Camera topCamera;
    private Camera backCamera;
    private Camera clamshellCamera;
    private Camera menuCamera;
    private float drivenDistance = 0.0f;
    private long lastTimestampForDistance = 0L;
    private long timestampForDistance = 0L;
    private int numDrills = 0;
    private boolean steeringLeft = false;
    private boolean steeringRight = false;
    private boolean accelerating = false;
    private boolean decelerating = false;
    private boolean reversing = false;
    private boolean clamshellFirstPartMovUp = false;
    private boolean clamshellFirstPartMovDown = false;
    private boolean clamshellFirstPartMovLeft = false;
    private boolean clamshellFirstPartMovRight = false;
    private boolean clamshellFirstPartRotLeft = false;
    private boolean clamshellFirstPartRotRight = false;
    private boolean clamshellSecondPartMovUp = false;
    private boolean clamshellSecondPartMovDown = false;
    private float clamshellFirstPartAngleMovUpDown = 0.0f;
    private float clamshellFirstPartAngleMovLeftRight = 0.0f;
    private float clamshellFirstPartAngleRotLeftRight = 0.0f;
    private float clamshellSecondPartAngleMovUpDown = 0.0f;
    private float clamshellFirstPartAngleMovUpDownMax = (float)Math.toRadians(50.0);
    private float clamshellFirstPartAngleMovLeftRightMax = (float)Math.toRadians(65.0);
    private float clamshellFirstPartAngleRotLeftRightMax = (float)Math.toRadians(90.0);
    private float clamshellSecondPartAngleMovUpDownMax = (float)Math.toRadians(65.0);
    Matrix4f tempFirstPart = new Matrix4f();
    Matrix4f tempSecondPart = new Matrix4f();
    Matrix4f tempRotXFirstPart = new Matrix4f();
    Matrix4f tempRotYFirstPart = new Matrix4f();
    Matrix4f tempRotZFirstPart = new Matrix4f();
    Matrix4f tempRotXSecondPart = new Matrix4f();

    public RoverVehicle(Camera camera, Camera camera2, Camera camera3, Camera camera4, Camera camera5) {
        this.frontCamera = camera;
        this.frontCamera.setPosition(new Vector3f(0.0f, 1.2f, -0.8f));
        this.frontCamera.setPitchOffset(-0.4f);
        this.frontCamera.setMinYaw(0.0f);
        this.frontCamera.setMaxYaw(0.0f);
        this.frontCamera.setMinPitch(0.0f);
        this.frontCamera.setMaxPitch(0.0f);
        this.backCamera = camera3;
        this.backCamera.setPosition(new Vector3f(0.0f, -0.45f, 0.5f));
        this.backCamera.setYawOffset((float)Math.PI);
        this.backCamera.setPitchOffset(0.1f);
        this.backCamera.setMinYaw(-0.3f);
        this.backCamera.setMaxYaw(0.3f);
        this.backCamera.setMinPitch(-0.2f);
        this.backCamera.setMaxPitch(0.2f);
        this.backCamera.setMouseSensitivity(1.0E-4f);
        this.topCamera = camera2;
        this.topCamera.setYaw(0.0f);
        this.topCamera.setPitch(0.4f);
        this.topCamera.setMinPitch(0.0f);
        this.topCamera.setMaxPitch(1.6f);
        this.topCamera.setMinDistance(5.0f);
        this.topCamera.setMaxDistance(40.0f);
        this.topCamera.setDistance(15.0f);
        this.clamshellCamera = camera4;
        this.clamshellCamera.setPosition(new Vector3f(0.0f, -0.3f, 0.0f));
        this.clamshellCamera.setPitchOffset(-0.4f);
        this.clamshellCamera.setMinYaw(0.0f);
        this.clamshellCamera.setMaxYaw(0.0f);
        this.clamshellCamera.setMinPitch(0.0f);
        this.clamshellCamera.setMaxPitch(0.0f);
        this.menuCamera = camera5;
        this.aktiveCamera = this.frontCamera;
    }

    public void buildRoverVehicle() {
        String string = "/res/models/rover/S.N.I.C.K.E.R.S.blend";
        Source source = null;
        try {
            source = Source.open("", new URI("file:///" + System.getProperty("user.dir").replaceAll("\\\\", "/") + string), Source.Type.BlenderFile);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        this.roverNodeAkku = this.buildRoverPart(source, "Akku");
        this.roverNodeAkku_Aufbau = this.buildRoverPart(source, "Akku_Aufbau");
        this.roverNodeFahrwerk = this.buildRoverPart(source, "Fahrwerk");
        this.roverNodeFischaugen = this.buildRoverPart(source, "Fischaugen");
        this.roverNodeKabel = this.buildRoverPart(source, "Kabel");
        this.roverNodeKameras = this.buildRoverPart(source, "Kameras");
        this.roverNodeMast_Halterung = this.buildRoverPart(source, "Mast_Halterung");
        this.roverNodeMast_Kopf = this.buildRoverPart(source, "Mast_Kopf");
        this.roverNodeMast_Kopf_Linsen = this.buildRoverPart(source, "Mast_Kopf_Linsen");
        this.roverNodeNaben = this.buildRoverPart(source, "Naben");
        this.roverNodeRadaufhaengungen = this.buildRoverPart(source, "Radaufhaengungen");
        this.roverNodeRover = this.buildRoverPart(source, "Rover");
        this.roverNodeScheinwerfer = this.buildRoverPart(source, "Scheinwerfer");
        this.roverNodeSchild = this.buildRoverPart(source, "Schild");
        this.roverNodeSchrauben = this.buildRoverPart(source, "Schrauben");
        this.roverNodeSolarzelle = this.buildRoverPart(source, "Solarzelle");
        this.roverNodeWheel1 = this.buildRoverPart(source, "Rad_Hinten_Links");
        this.roverNodeWheel2 = this.buildRoverPart(source, "Rad_Hinten_Rechts");
        this.roverNodeWheel3 = this.buildRoverPart(source, "Rad_Mitte_Links");
        this.roverNodeWheel4 = this.buildRoverPart(source, "Rad_Mitte_Rechts");
        this.roverNodeWheel5 = this.buildRoverPart(source, "Rad_Vorne_Links");
        this.roverNodeWheel6 = this.buildRoverPart(source, "Rad_Vorne_Rechts");
        this.roverNodeClamshellFirstPartGeometry = this.buildRoverPart(source, "Arm");
        this.roverNodeClamshellSecondPartGeometry = this.buildRoverPart(source, "Werkzeug");
        this.initializeTextures();
        this.roverNodeAkku.setTexture((Texture)this.roverTextures.get("Akku"));
        this.roverNodeAkku_Aufbau.setTexture((Texture)this.roverTextures.get("Akku_Util"));
        this.roverNodeFahrwerk.setTexture((Texture)this.roverTextures.get("Metal"));
        this.roverNodeFischaugen.setTexture((Texture)this.roverTextures.get("Camera"));
        this.roverNodeKabel.setTexture((Texture)this.roverTextures.get("Black"));
        this.roverNodeKameras.setTexture((Texture)this.roverTextures.get("Black_Plastic"));
        this.roverNodeMast_Halterung.setTexture((Texture)this.roverTextures.get("Metal"));
        this.roverNodeMast_Kopf.setTexture((Texture)this.roverTextures.get("Corrode_Metal1"));
        this.roverNodeMast_Kopf_Linsen.setTexture((Texture)this.roverTextures.get("Camera"));
        this.roverNodeNaben.setTexture((Texture)this.roverTextures.get("Corrode_Metal2"));
        this.roverNodeRadaufhaengungen.setTexture((Texture)this.roverTextures.get("Metal"));
        this.roverNodeRover.setTexture((Texture)this.roverTextures.get("Corrode_Metal1"));
        this.roverNodeScheinwerfer.setTexture((Texture)this.roverTextures.get("Spotlight_Off"));
        this.roverNodeSchild.setTexture((Texture)this.roverTextures.get("Label"));
        this.roverNodeSchrauben.setTexture((Texture)this.roverTextures.get("Corrode_Metal3"));
        this.roverNodeSolarzelle.setTexture((Texture)this.roverTextures.get("Solar_Panel"));
        this.roverNodeWheel1.setTexture((Texture)this.roverTextures.get("Rubber"));
        this.roverNodeWheel2.setTexture((Texture)this.roverTextures.get("Rubber"));
        this.roverNodeWheel3.setTexture((Texture)this.roverTextures.get("Rubber"));
        this.roverNodeWheel4.setTexture((Texture)this.roverTextures.get("Rubber"));
        this.roverNodeWheel5.setTexture((Texture)this.roverTextures.get("Rubber"));
        this.roverNodeWheel6.setTexture((Texture)this.roverTextures.get("Rubber"));
        this.roverNodeClamshellFirstPartGeometry.setTexture((Texture)this.roverTextures.get("Metal"));
        this.roverNodeClamshellSecondPartGeometry.setTexture((Texture)this.roverTextures.get("Metal"));
        this.buildFlashLight();
        this.buildPhysicsElement();
        this.lastTimestampForDistance = System.currentTimeMillis();
    }

    private void buildPhysicsElement() {
        this.gre = AbstractElementFactory.getInstance().createGenericRoverElement(this);
    }

    public void initializeAfterBuilt(JBulletWorld jBulletWorld) {
        ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).initializeAfterBuilt(jBulletWorld);
    }

    @Override
    public void updateChanged() {
        this.roverNodeBody.setRelativeRotation(((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getRotationMatrixBody());
        this.roverNodeBody.setRelativeTranslation(((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getTranslationMatrixBody());
        this.roverNodeWheel1.setRelativeRotation(((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getRotationMatrixWheel1());
        this.roverNodeWheel1.setRelativeTranslation(((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getTranslationMatrixWheel1());
        this.roverNodeWheel2.setRelativeRotation(((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getRotationMatrixWheel2());
        this.roverNodeWheel2.setRelativeTranslation(((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getTranslationMatrixWheel2());
        this.roverNodeWheel3.setRelativeRotation(((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getRotationMatrixWheel3());
        this.roverNodeWheel3.setRelativeTranslation(((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getTranslationMatrixWheel3());
        this.roverNodeWheel4.setRelativeRotation(((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getRotationMatrixWheel4());
        this.roverNodeWheel4.setRelativeTranslation(((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getTranslationMatrixWheel4());
        this.roverNodeWheel5.setRelativeRotation(((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getRotationMatrixWheel5());
        this.roverNodeWheel5.setRelativeTranslation(((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getTranslationMatrixWheel5());
        this.roverNodeWheel6.setRelativeRotation(((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getRotationMatrixWheel6());
        this.roverNodeWheel6.setRelativeTranslation(((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getTranslationMatrixWheel6());
        this.drill();
    }

    public Vector3f getForwardVector() {
        return ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getForwardVector();
    }

    public float getCurrentSpeedKmHour() {
        return ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getCurrentSpeedKmHour();
    }

    @Override
    public WorldElement getPhysicalElement() {
        return this.gre;
    }

    @Override
    public FloatBuffer getVertexPositions() {
        System.out.println("FEHLER: getVertexPositions() fuer RoverVehicle nicht implementiert:");
        System.out.println("\tWird momentan nicht benoetigt; ggf. muss aber die Kombination aller Vertices");
        System.out.println("\tvon Body und aller beteiligten Raeder zurueckgegeben werden!!");
        return null;
    }

    @Override
    public IntBuffer getVertexPositionIndices() {
        System.out.println("FEHLER: getVertexPositionIndices() fuer RoverVehicle nicht implementiert:");
        System.out.println("\tWird momentan nicht benoetigt; ggf. muss aber die Kombination aller Indices");
        System.out.println("\tvon Body und aller beteiligten Raeder zurueckgegeben werden!!");
        return null;
    }

    @Override
    public void handle(MouseEvent mouseEvent) {
        if (this.aktiveCamera == this.topCamera) {
            if (mouseEvent.getDWheel() > 0) {
                this.aktiveCamera.increaseDistance();
            }
            if (mouseEvent.getDWheel() < 0) {
                this.aktiveCamera.decreaseDistance();
            }
            this.calculateYaw((float)mouseEvent.getDeltaX() * this.aktiveCamera.getMouseSensitivity());
            this.calculatePitch((float)(-mouseEvent.getDeltaY()) * this.aktiveCamera.getMouseSensitivity());
        } else {
            this.calculateYaw((float)(-mouseEvent.getDeltaX()) * this.aktiveCamera.getMouseSensitivity());
            this.calculatePitch((float)(-mouseEvent.getDeltaY()) * this.aktiveCamera.getMouseSensitivity());
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKey()) {
            case 17: {
                this.accelerating = true;
                break;
            }
            case 31: {
                this.decelerating = true;
                break;
            }
            case 45: {
                this.reversing = true;
                break;
            }
            case 30: {
                this.steeringLeft = true;
                break;
            }
            case 32: {
                this.steeringRight = true;
                break;
            }
            case 33: {
                if (!this.fl_status) {
                    this.switchFlashlight(true);
                    this.roverNodeScheinwerfer.setTexture((Texture)this.roverTextures.get("Spotlight_On"));
                    this.fl_status = true;
                    break;
                }
                this.switchFlashlight(false);
                this.roverNodeScheinwerfer.setTexture((Texture)this.roverTextures.get("Spotlight_Off"));
                this.fl_status = false;
                break;
            }
            case 48: {
                if (this.accelerating || this.reversing || !(Math.abs(this.getCurrentSpeedKmHour()) < 1.5f)) break;
                this.startDrill = true;
                break;
            }
            case 2: {
                this.aktiveCamera = this.frontCamera;
                this.setCameraActive();
                break;
            }
            case 3: {
                this.aktiveCamera = this.topCamera;
                this.setCameraActive();
                break;
            }
            case 4: {
                this.aktiveCamera = this.backCamera;
                this.setCameraActive();
                break;
            }
            case 5: {
                this.aktiveCamera = this.clamshellCamera;
                this.setCameraActive();
            }
        }
        if (!this.startDrill) {
            switch (keyEvent.getKey()) {
                case 20: {
                    this.clamshellFirstPartMovUp = true;
                    break;
                }
                case 34: {
                    this.clamshellFirstPartMovDown = true;
                    break;
                }
                case 44: {
                    this.clamshellFirstPartMovLeft = true;
                    break;
                }
                case 35: {
                    this.clamshellFirstPartMovRight = true;
                    break;
                }
                case 22: {
                    this.clamshellFirstPartRotLeft = true;
                    break;
                }
                case 36: {
                    this.clamshellFirstPartRotRight = true;
                    break;
                }
                case 23: {
                    this.clamshellSecondPartMovUp = true;
                    break;
                }
                case 37: {
                    this.clamshellSecondPartMovDown = true;
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKey()) {
            case 17: {
                this.accelerating = false;
                break;
            }
            case 31: {
                this.decelerating = false;
                break;
            }
            case 45: {
                this.reversing = false;
                break;
            }
            case 30: {
                this.steeringLeft = false;
                break;
            }
            case 32: {
                this.steeringRight = false;
            }
        }
        if (!this.startDrill) {
            switch (keyEvent.getKey()) {
                case 20: {
                    this.clamshellFirstPartMovUp = false;
                    break;
                }
                case 34: {
                    this.clamshellFirstPartMovDown = false;
                    break;
                }
                case 44: {
                    this.clamshellFirstPartMovLeft = false;
                    break;
                }
                case 35: {
                    this.clamshellFirstPartMovRight = false;
                    break;
                }
                case 22: {
                    this.clamshellFirstPartRotLeft = false;
                    break;
                }
                case 36: {
                    this.clamshellFirstPartRotRight = false;
                    break;
                }
                case 23: {
                    this.clamshellSecondPartMovUp = false;
                    break;
                }
                case 37: {
                    this.clamshellSecondPartMovDown = false;
                }
            }
        }
    }

    @Override
    public void update() {
        float f;
        if (this.accelerating && !this.startDrill) {
            f = ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getMaxEngineForce();
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).applyEngineForce(-f, 0);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setBrake(0.0f, 0);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).applyEngineForce(-f, 1);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setBrake(0.0f, 1);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).applyEngineForce(-f, 2);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setBrake(0.0f, 2);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).applyEngineForce(-f, 3);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setBrake(0.0f, 3);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).applyEngineForce(-f, 4);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setBrake(0.0f, 4);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).applyEngineForce(-f, 5);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setBrake(0.0f, 5);
        } else if (this.decelerating) {
            f = ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getMaxBreakingForce();
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).applyEngineForce(0.0f, 0);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setBrake(f, 0);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).applyEngineForce(0.0f, 1);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setBrake(f, 1);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).applyEngineForce(0.0f, 2);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setBrake(f, 2);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).applyEngineForce(0.0f, 3);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setBrake(f, 3);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).applyEngineForce(0.0f, 4);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setBrake(f, 4);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).applyEngineForce(0.0f, 5);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setBrake(f, 5);
        } else if (this.reversing && !this.startDrill) {
            f = ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getMaxEngineForce();
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).applyEngineForce(f, 0);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setBrake(0.0f, 0);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).applyEngineForce(f, 1);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setBrake(0.0f, 1);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).applyEngineForce(f, 2);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setBrake(0.0f, 2);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).applyEngineForce(f, 3);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setBrake(0.0f, 3);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).applyEngineForce(f, 4);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setBrake(0.0f, 4);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).applyEngineForce(f, 5);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setBrake(0.0f, 5);
        } else {
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).applyEngineForce(0.0f, 0);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setBrake(10.0f, 0);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).applyEngineForce(0.0f, 1);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setBrake(10.0f, 1);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).applyEngineForce(0.0f, 2);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setBrake(10.0f, 2);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).applyEngineForce(0.0f, 3);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setBrake(10.0f, 3);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).applyEngineForce(0.0f, 4);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setBrake(10.0f, 4);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).applyEngineForce(0.0f, 5);
            ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setBrake(10.0f, 5);
        }
        if (this.steeringLeft) {
            f = ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getVehicleSteering();
            if (f > -((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getSteeringClamp()) {
                ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setSteeringValueForWholeRover(f -= ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getSteeringIncrement());
            }
        } else if (this.steeringRight) {
            f = ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getVehicleSteering();
            if (f < ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getSteeringClamp()) {
                ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setSteeringValueForWholeRover(f += ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getSteeringIncrement());
            }
        } else if (!this.steeringLeft && !this.steeringRight) {
            f = ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getVehicleSteering();
            if (f < 0.0f - ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getSteeringIncrement()) {
                ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setSteeringValueForWholeRover(f += ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getSteeringIncrement());
            } else if (f > 0.0f + ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getSteeringIncrement()) {
                ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).setSteeringValueForWholeRover(f -= ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getSteeringIncrement());
            }
        }
        this.tempRotXFirstPart.setIdentity();
        this.tempRotYFirstPart.setIdentity();
        this.tempRotZFirstPart.setIdentity();
        this.tempRotXSecondPart.setIdentity();
        if (this.clamshellFirstPartMovUp) {
            if (this.clamshellFirstPartAngleMovUpDownMax > this.clamshellFirstPartAngleMovUpDown) {
                this.clamshellFirstPartAngleMovUpDown = (float)((double)this.clamshellFirstPartAngleMovUpDown + 0.005);
            }
        } else if (this.clamshellFirstPartMovDown && (double)Math.abs(this.clamshellFirstPartAngleMovUpDownMax) > (double)Math.abs(this.clamshellFirstPartAngleMovUpDown) - 0.01) {
            this.clamshellFirstPartAngleMovUpDown = (float)((double)this.clamshellFirstPartAngleMovUpDown - 0.005);
        }
        this.tempRotXFirstPart.m11 = (float)Math.cos(this.clamshellFirstPartAngleMovUpDown);
        this.tempRotXFirstPart.m12 = -((float)Math.sin(this.clamshellFirstPartAngleMovUpDown));
        this.tempRotXFirstPart.m21 = (float)Math.sin(this.clamshellFirstPartAngleMovUpDown);
        this.tempRotXFirstPart.m22 = (float)Math.cos(this.clamshellFirstPartAngleMovUpDown);
        if (this.clamshellFirstPartMovLeft) {
            if ((double)Math.abs(this.clamshellFirstPartAngleMovLeftRightMax) > (double)Math.abs(this.clamshellFirstPartAngleMovLeftRight) - 0.01) {
                this.clamshellFirstPartAngleMovLeftRight = (float)((double)this.clamshellFirstPartAngleMovLeftRight - 0.005);
            }
        } else if (this.clamshellFirstPartMovRight && this.clamshellFirstPartAngleMovLeftRightMax > this.clamshellFirstPartAngleMovLeftRight) {
            this.clamshellFirstPartAngleMovLeftRight = (float)((double)this.clamshellFirstPartAngleMovLeftRight + 0.005);
        }
        this.tempRotYFirstPart.m00 = (float)Math.cos(this.clamshellFirstPartAngleMovLeftRight);
        this.tempRotYFirstPart.m02 = (float)Math.sin(this.clamshellFirstPartAngleMovLeftRight);
        this.tempRotYFirstPart.m20 = -((float)Math.sin(this.clamshellFirstPartAngleMovLeftRight));
        this.tempRotYFirstPart.m22 = (float)Math.cos(this.clamshellFirstPartAngleMovLeftRight);
        if (this.clamshellFirstPartRotLeft) {
            if ((double)Math.abs(this.clamshellFirstPartAngleRotLeftRightMax) > (double)Math.abs(this.clamshellFirstPartAngleRotLeftRight) - 0.01) {
                this.clamshellFirstPartAngleRotLeftRight = (float)((double)this.clamshellFirstPartAngleRotLeftRight - 0.005);
            }
        } else if (this.clamshellFirstPartRotRight && this.clamshellFirstPartAngleRotLeftRightMax > this.clamshellFirstPartAngleRotLeftRight) {
            this.clamshellFirstPartAngleRotLeftRight = (float)((double)this.clamshellFirstPartAngleRotLeftRight + 0.005);
        }
        this.tempRotZFirstPart.m00 = (float)Math.cos(this.clamshellFirstPartAngleRotLeftRight);
        this.tempRotZFirstPart.m01 = -((float)Math.sin(this.clamshellFirstPartAngleRotLeftRight));
        this.tempRotZFirstPart.m10 = (float)Math.sin(this.clamshellFirstPartAngleRotLeftRight);
        this.tempRotZFirstPart.m11 = (float)Math.cos(this.clamshellFirstPartAngleRotLeftRight);
        if (this.clamshellSecondPartMovUp) {
            if (this.clamshellSecondPartAngleMovUpDownMax > this.clamshellSecondPartAngleMovUpDown) {
                this.clamshellSecondPartAngleMovUpDown = (float)((double)this.clamshellSecondPartAngleMovUpDown + 0.005);
            }
        } else if (this.clamshellSecondPartMovDown && (double)Math.abs(this.clamshellSecondPartAngleMovUpDownMax) > (double)Math.abs(this.clamshellSecondPartAngleMovUpDown) - 0.01) {
            this.clamshellSecondPartAngleMovUpDown = (float)((double)this.clamshellSecondPartAngleMovUpDown - 0.005);
        }
        this.tempRotXSecondPart.m11 = (float)Math.cos(this.clamshellSecondPartAngleMovUpDown);
        this.tempRotXSecondPart.m12 = -((float)Math.sin(this.clamshellSecondPartAngleMovUpDown));
        this.tempRotXSecondPart.m21 = (float)Math.sin(this.clamshellSecondPartAngleMovUpDown);
        this.tempRotXSecondPart.m22 = (float)Math.cos(this.clamshellSecondPartAngleMovUpDown);
        this.tempFirstPart.setIdentity();
        this.tempFirstPart.mul(this.tempRotXFirstPart, this.tempRotYFirstPart);
        this.tempFirstPart.mul(this.tempRotZFirstPart);
        this.tempSecondPart.setIdentity();
        this.tempSecondPart.mul(this.tempRotXSecondPart);
        this.roverNodeClamshellFirstPartRotations.setRelativeRotation(this.tempFirstPart);
        this.roverNodeClamshellSecondPartRotations.setRelativeRotation(this.tempSecondPart);
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setIdentity();
        Matrix4f matrix4f2 = new Matrix4f();
        matrix4f2.setIdentity();
        matrix4f.m13 = 0.16f;
        matrix4f.m23 = -1.8f;
        matrix4f2.m23 = -1.5f;
        this.roverNodeClamshellFirstPartRotations.setRelativeTranslation(matrix4f);
        this.roverNodeClamshellSecondPartRotations.setRelativeTranslation(matrix4f2);
    }

    private void calculateYaw(float f) {
        this.aktiveCamera.setYaw(this.aktiveCamera.getYaw() + f);
    }

    private void calculatePitch(float f) {
        this.aktiveCamera.setPitch(this.aktiveCamera.getPitch() + f);
    }

    public void setPosition(Vector3f vector3f) {
        this.gre.setPosition(vector3f);
    }

    public Vector3f getBodyPosition() {
        return ((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.gre)).getTranslationMatrixBody();
    }

    @Override
    public void setCameraActive() {
        this.aktiveCamera.setActive(true);
    }

    private void buildFlashLight() {
        this.flashlight = new Flashlight();
        this.roverLight = this.flashlight.buildlight();
    }

    public Node buildRoverFlashLight() {
        this.buildFlashLight();
        return this.roverLight;
    }

    private void switchFlashlight(boolean bl) {
        if (bl) {
            this.flashlight.setIntensity(1.0f);
        } else {
            this.flashlight.setIntensity(0.0f);
        }
    }

    public Node buildRoverNode(JBulletWorld jBulletWorld) {
        this.buildRoverVehicle();
        this.initializeAfterBuilt(jBulletWorld);
        ((GroupNode)this.roverNodeBody).add(this.roverNodeRover);
        ((GroupNode)this.roverNodeBody).add(this.roverNodeAkku);
        ((GroupNode)this.roverNodeBody).add(this.roverNodeAkku_Aufbau);
        ((GroupNode)this.roverNodeBody).add(this.roverNodeFahrwerk);
        ((GroupNode)this.roverNodeBody).add(this.roverNodeFischaugen);
        ((GroupNode)this.roverNodeBody).add(this.roverNodeKabel);
        ((GroupNode)this.roverNodeBody).add(this.roverNodeKameras);
        ((GroupNode)this.roverNodeBody).add(this.roverNodeMast_Halterung);
        ((GroupNode)this.roverNodeBody).add(this.roverNodeMast_Kopf);
        ((GroupNode)this.roverNodeBody).add(this.roverNodeMast_Kopf_Linsen);
        ((GroupNode)this.roverNodeBody).add(this.roverNodeNaben);
        ((GroupNode)this.roverNodeBody).add(this.roverNodeRadaufhaengungen);
        ((GroupNode)this.roverNodeBody).add(this.roverNodeScheinwerfer);
        ((GroupNode)this.roverNodeBody).add(this.roverNodeSchild);
        ((GroupNode)this.roverNodeBody).add(this.roverNodeSchrauben);
        ((GroupNode)this.roverNodeBody).add(this.roverNodeSolarzelle);
        ((GroupNode)this.roverNodeBody).add(this.roverLight);
        ((GroupNode)this.roverNodeBody).add((Node)((Object)this.frontCamera));
        ((GroupNode)this.roverNodeBody).add((Node)((Object)this.backCamera));
        ((GroupNode)this.roverNodeBody).add((Node)((Object)this.topCamera));
        ((GroupNode)this.roverNodeBody).add((Node)((Object)this.menuCamera));
        ((GroupNode)this.roverNodeBody).add(this.roverNodeClamshellFirstPartRotations);
        ((GroupNode)this.roverNodeClamshellFirstPartRotations).add(this.roverNodeClamshellFirstPartTranslations);
        ((GroupNode)this.roverNodeClamshellFirstPartTranslations).add(this.roverNodeClamshellSecondPartRotations);
        ((GroupNode)this.roverNodeClamshellSecondPartRotations).add(this.roverNodeClamshellSecondPartTranslations);
        ((GroupNode)this.roverNodeClamshellFirstPartTranslations).add(this.roverNodeClamshellFirstPartGeometry);
        ((GroupNode)this.roverNodeClamshellSecondPartTranslations).add(this.roverNodeClamshellSecondPartGeometry);
        ((GroupNode)this.roverNodeClamshellSecondPartTranslations).add((Node)((Object)this.clamshellCamera));
        ((GroupNode)this.roverParentNode).add(this.roverNodeWheel1);
        ((GroupNode)this.roverParentNode).add(this.roverNodeWheel2);
        ((GroupNode)this.roverParentNode).add(this.roverNodeWheel3);
        ((GroupNode)this.roverParentNode).add(this.roverNodeWheel4);
        ((GroupNode)this.roverParentNode).add(this.roverNodeWheel5);
        ((GroupNode)this.roverParentNode).add(this.roverNodeWheel6);
        ((GroupNode)this.roverParentNode).add(this.roverNodeBody);
        jBulletWorld.addJBulletAbstractRaycastVehicleElementRepresentation((JBulletAbstractRaycastVehicleElementRepresentation)((Object)this.getPhysicalElement()));
        this.setPosition(new Vector3f(0.0f, 3.0f, 0.0f));
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setIdentity();
        Matrix4f matrix4f2 = new Matrix4f();
        matrix4f2.setIdentity();
        matrix4f.m13 = 0.16f;
        matrix4f.m23 = -1.8f;
        matrix4f2.m23 = -1.5f;
        this.roverNodeClamshellFirstPartRotations.setRelativeTranslation(matrix4f);
        this.roverNodeClamshellSecondPartRotations.setRelativeTranslation(matrix4f2);
        return this.roverParentNode;
    }

    public float getDrivenDistance() {
        this.timestampForDistance = System.currentTimeMillis();
        long l = this.timestampForDistance - this.lastTimestampForDistance;
        this.drivenDistance = (float)((double)this.drivenDistance + Math.floor(Math.abs(this.getCurrentSpeedKmHour())) / (double)(l * 1000L * 60L * 60L) * 1000.0);
        this.lastTimestampForDistance = this.timestampForDistance;
        return this.drivenDistance;
    }

    public int getNumDrills() {
        return this.numDrills;
    }

    public void drill() {
        if (this.startDrill) {
            if (this.drillStep == -1) {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                if ((double)this.clamshellFirstPartAngleRotLeftRight != Math.toRadians(0.01)) {
                    if ((double)this.clamshellFirstPartAngleRotLeftRight < Math.toRadians(-0.2)) {
                        this.clamshellFirstPartRotRight = true;
                        this.clamshellFirstPartRotLeft = false;
                    } else if ((double)this.clamshellFirstPartAngleRotLeftRight > Math.toRadians(0.2)) {
                        this.clamshellFirstPartRotRight = false;
                        this.clamshellFirstPartRotLeft = true;
                    } else if ((double)Math.abs(this.clamshellFirstPartAngleRotLeftRight) < Math.toRadians(0.1)) {
                        this.clamshellFirstPartRotRight = false;
                        this.clamshellFirstPartRotLeft = false;
                        bl = true;
                    }
                }
                if ((double)this.clamshellFirstPartAngleMovUpDown != Math.toRadians(0.01)) {
                    if (this.clamshellFirstPartAngleMovUpDown < (float)Math.toRadians(-0.2)) {
                        this.clamshellFirstPartMovDown = false;
                        this.clamshellFirstPartMovUp = true;
                    } else if (this.clamshellFirstPartAngleMovUpDown > (float)Math.toRadians(0.2)) {
                        this.clamshellFirstPartMovDown = true;
                        this.clamshellFirstPartMovUp = false;
                    } else if (Math.abs(this.clamshellFirstPartAngleMovUpDown) < (float)Math.toRadians(0.1)) {
                        this.clamshellFirstPartMovDown = false;
                        this.clamshellFirstPartMovUp = false;
                        bl2 = true;
                    }
                }
                if ((double)this.clamshellFirstPartAngleMovLeftRight != Math.toRadians(0.01)) {
                    if (this.clamshellFirstPartAngleMovLeftRight < (float)Math.toRadians(-0.2)) {
                        this.clamshellFirstPartMovLeft = false;
                        this.clamshellFirstPartMovRight = true;
                    } else if (this.clamshellFirstPartAngleMovLeftRight > (float)Math.toRadians(0.2)) {
                        this.clamshellFirstPartMovLeft = true;
                        this.clamshellFirstPartMovRight = false;
                    } else if (Math.abs(this.clamshellFirstPartAngleMovLeftRight) < (float)Math.toRadians(0.1)) {
                        this.clamshellFirstPartMovLeft = false;
                        this.clamshellFirstPartMovRight = false;
                        bl3 = true;
                    }
                }
                if ((double)this.clamshellSecondPartAngleMovUpDown != Math.toRadians(0.01)) {
                    if (this.clamshellSecondPartAngleMovUpDown < (float)Math.toRadians(-0.2)) {
                        this.clamshellSecondPartMovDown = false;
                        this.clamshellSecondPartMovUp = true;
                    } else if (this.clamshellSecondPartAngleMovUpDown > (float)Math.toRadians(0.2)) {
                        this.clamshellSecondPartMovDown = true;
                        this.clamshellSecondPartMovUp = false;
                    } else if (Math.abs(this.clamshellSecondPartAngleMovUpDown) < (float)Math.toRadians(0.1)) {
                        this.clamshellSecondPartMovDown = false;
                        this.clamshellSecondPartMovUp = false;
                        bl4 = true;
                    }
                }
                if (bl && bl2 && bl3 && bl4) {
                    this.drillStep = 0;
                }
            }
            if (this.drillStep == 0 && this.clamshellFirstPartAngleMovUpDown > (float)Math.toRadians(-45.0)) {
                this.clamshellFirstPartMovDown = true;
                this.clamshellSecondPartMovUp = true;
                ++this.drillStep;
            }
            if (this.drillStep == 1 && this.clamshellFirstPartAngleMovUpDown < (float)Math.toRadians(-50.0)) {
                this.clamshellFirstPartMovDown = false;
                this.clamshellSecondPartMovUp = false;
                this.clamshellFirstPartMovUp = true;
                this.clamshellSecondPartMovDown = true;
                ++this.drillStep;
                ++this.numDrills;
                this.setLastDrillPosition(this.roverNodeBody.getAbsoluteTranslation());
            }
            if (this.drillStep == 2 && Math.abs(this.clamshellSecondPartAngleMovUpDown) < (float)Math.toRadians(0.1) && Math.abs(this.clamshellFirstPartAngleMovUpDown) < (float)Math.toRadians(0.1)) {
                this.clamshellFirstPartMovUp = false;
                this.clamshellSecondPartMovDown = false;
                this.startDrill = false;
                this.drillStep = -1;
            }
        }
    }

    public void buildRoverTexture(GeometryNode geometryNode, String string, String string2) {
        NativeTexture nativeTexture = (NativeTexture)NativeObjectFactory.getInstance().createTexture();
        TextureDescriptor textureDescriptor = (TextureDescriptor)nativeTexture.getDescriptor();
        textureDescriptor.setName(string2);
        try {
            textureDescriptor.setSource(Source.open("", new URI("file:///" + System.getProperty("user.dir").replaceAll("\\\\", "/") + string), Source.Type.PNGFile));
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        AssetLoader.getInstance().load(nativeTexture);
        nativeTexture.bind();
        nativeTexture.buffer();
        geometryNode.setTexture(nativeTexture);
    }

    private GeometryNode buildRoverPart(Source source, String string) {
        GeometryNode geometryNode = new GeometryNode(string);
        NativeMesh nativeMesh = (NativeMesh)NativeObjectFactory.getInstance().createMesh();
        MeshDescriptor meshDescriptor = (MeshDescriptor)nativeMesh.getDescriptor();
        meshDescriptor.setSource(source);
        meshDescriptor.setName(string);
        meshDescriptor.setMode(Mesh.Mode.Triangles);
        AssetLoader assetLoader = AssetLoader.getInstance();
        assetLoader.load(nativeMesh);
        nativeMesh.bind();
        NativeVertexBuffer nativeVertexBuffer = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Position);
        nativeVertexBuffer.buffer();
        NativeVertexBuffer nativeVertexBuffer2 = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Index);
        nativeVertexBuffer2.buffer();
        NativeVertexBuffer nativeVertexBuffer3 = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.TexturCoordinate);
        nativeVertexBuffer3.buffer();
        nativeMesh.unbind();
        geometryNode.setMesh(nativeMesh);
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setIdentity();
        matrix4f.m22 = 0.4f;
        matrix4f.m11 = 0.4f;
        matrix4f.m00 = 0.4f;
        geometryNode.setRelativeScaling(matrix4f);
        return geometryNode;
    }

    public Vector3f getLastDrillPosition() {
        Vector3f vector3f = this.lastDrillPosition;
        this.lastDrillPosition = null;
        return vector3f;
    }

    public void setLastDrillPosition(Matrix4f matrix4f) {
        Vector3f vector3f = new Vector3f();
        matrix4f.get(vector3f);
        this.lastDrillPosition = vector3f;
    }

    private void initializeTextures() {
        AssetLoader assetLoader = AssetLoader.getInstance();
        String string = "/res/textures/rover/Akku.png";
        NativeTexture nativeTexture = (NativeTexture)NativeObjectFactory.getInstance().createTexture();
        TextureDescriptor textureDescriptor = (TextureDescriptor)nativeTexture.getDescriptor();
        textureDescriptor.setName("Akku");
        try {
            textureDescriptor.setSource(Source.open("Akku_Textur_Source", new URI("file:///" + System.getProperty("user.dir").replaceAll("\\\\", "/") + string), Source.Type.PNGFile));
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        this.roverTextures.add(nativeTexture);
        NativeTexture nativeTexture2 = (NativeTexture)NativeObjectFactory.getInstance().createTexture();
        TextureDescriptor textureDescriptor2 = (TextureDescriptor)nativeTexture2.getDescriptor();
        textureDescriptor2.setName("Akku_Util");
        string = "/res/textures/rover/Akku_Util.png";
        try {
            textureDescriptor2.setSource(Source.open("Akku_Util_Textur_Source", new URI("file:///" + System.getProperty("user.dir").replaceAll("\\\\", "/") + string), Source.Type.PNGFile));
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        this.roverTextures.add(nativeTexture2);
        NativeTexture nativeTexture3 = (NativeTexture)NativeObjectFactory.getInstance().createTexture();
        TextureDescriptor textureDescriptor3 = (TextureDescriptor)nativeTexture3.getDescriptor();
        textureDescriptor3.setName("Metal");
        string = "/res/textures/rover/Metal.png";
        try {
            textureDescriptor3.setSource(Source.open("Metal_Textur_Source", new URI("file:///" + System.getProperty("user.dir").replaceAll("\\\\", "/") + string), Source.Type.PNGFile));
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        this.roverTextures.add(nativeTexture3);
        NativeTexture nativeTexture4 = (NativeTexture)NativeObjectFactory.getInstance().createTexture();
        TextureDescriptor textureDescriptor4 = (TextureDescriptor)nativeTexture4.getDescriptor();
        textureDescriptor4.setName("Camera");
        string = "/res/textures/rover/Camera.png";
        try {
            textureDescriptor4.setSource(Source.open("Camera_Source", new URI("file:///" + System.getProperty("user.dir").replaceAll("\\\\", "/") + string), Source.Type.PNGFile));
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        this.roverTextures.add(nativeTexture4);
        NativeTexture nativeTexture5 = (NativeTexture)NativeObjectFactory.getInstance().createTexture();
        TextureDescriptor textureDescriptor5 = (TextureDescriptor)nativeTexture5.getDescriptor();
        textureDescriptor5.setName("Black");
        string = "/res/textures/rover/Black.png";
        try {
            textureDescriptor5.setSource(Source.open("Black_Textur_Source", new URI("file:///" + System.getProperty("user.dir").replaceAll("\\\\", "/") + string), Source.Type.PNGFile));
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        this.roverTextures.add(nativeTexture5);
        NativeTexture nativeTexture6 = (NativeTexture)NativeObjectFactory.getInstance().createTexture();
        TextureDescriptor textureDescriptor6 = (TextureDescriptor)nativeTexture6.getDescriptor();
        textureDescriptor6.setName("Black_Plastic");
        string = "/res/textures/rover/Black_Plastic.png";
        try {
            textureDescriptor6.setSource(Source.open("Black_Plastic_Textur_Source", new URI("file:///" + System.getProperty("user.dir").replaceAll("\\\\", "/") + string), Source.Type.PNGFile));
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        this.roverTextures.add(nativeTexture6);
        NativeTexture nativeTexture7 = (NativeTexture)NativeObjectFactory.getInstance().createTexture();
        TextureDescriptor textureDescriptor7 = (TextureDescriptor)nativeTexture7.getDescriptor();
        textureDescriptor7.setName("Corrode_Metal1");
        string = "/res/textures/rover/Corrode_Metal1.png";
        try {
            textureDescriptor7.setSource(Source.open("Corrode_Metal1_Textur_Source", new URI("file:///" + System.getProperty("user.dir").replaceAll("\\\\", "/") + string), Source.Type.PNGFile));
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        this.roverTextures.add(nativeTexture7);
        NativeTexture nativeTexture8 = (NativeTexture)NativeObjectFactory.getInstance().createTexture();
        TextureDescriptor textureDescriptor8 = (TextureDescriptor)nativeTexture8.getDescriptor();
        textureDescriptor8.setName("Corrode_Metal2");
        string = "/res/textures/rover/Corrode_Metal2.png";
        try {
            textureDescriptor8.setSource(Source.open("Corrode_Metal2_Textur_Source", new URI("file:///" + System.getProperty("user.dir").replaceAll("\\\\", "/") + string), Source.Type.PNGFile));
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        this.roverTextures.add(nativeTexture8);
        NativeTexture nativeTexture9 = (NativeTexture)NativeObjectFactory.getInstance().createTexture();
        TextureDescriptor textureDescriptor9 = (TextureDescriptor)nativeTexture9.getDescriptor();
        textureDescriptor9.setName("Spotlight_Off");
        string = "/res/textures/rover/Spotlight_Off.png";
        try {
            textureDescriptor9.setSource(Source.open("Spotlight_Off_Textur_Source", new URI("file:///" + System.getProperty("user.dir").replaceAll("\\\\", "/") + string), Source.Type.PNGFile));
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        this.roverTextures.add(nativeTexture9);
        NativeTexture nativeTexture10 = (NativeTexture)NativeObjectFactory.getInstance().createTexture();
        TextureDescriptor textureDescriptor10 = (TextureDescriptor)nativeTexture10.getDescriptor();
        textureDescriptor10.setName("Spotlight_On");
        string = "/res/textures/rover/Spotlight_On.png";
        try {
            textureDescriptor10.setSource(Source.open("Spotlight_On_Textur_Source", new URI("file:///" + System.getProperty("user.dir").replaceAll("\\\\", "/") + string), Source.Type.PNGFile));
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        this.roverTextures.add(nativeTexture10);
        NativeTexture nativeTexture11 = (NativeTexture)NativeObjectFactory.getInstance().createTexture();
        TextureDescriptor textureDescriptor11 = (TextureDescriptor)nativeTexture11.getDescriptor();
        textureDescriptor11.setName("Label");
        string = "/res/textures/rover/Label.png";
        try {
            textureDescriptor11.setSource(Source.open("Label_Textur_Source", new URI("file:///" + System.getProperty("user.dir").replaceAll("\\\\", "/") + string), Source.Type.PNGFile));
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        this.roverTextures.add(nativeTexture11);
        NativeTexture nativeTexture12 = (NativeTexture)NativeObjectFactory.getInstance().createTexture();
        TextureDescriptor textureDescriptor12 = (TextureDescriptor)nativeTexture12.getDescriptor();
        textureDescriptor12.setName("Corrode_Metal3");
        string = "/res/textures/rover/Corrode_Metal3.png";
        try {
            textureDescriptor12.setSource(Source.open("Corrode_Metal3_Textur_Source", new URI("file:///" + System.getProperty("user.dir").replaceAll("\\\\", "/") + string), Source.Type.PNGFile));
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        this.roverTextures.add(nativeTexture12);
        NativeTexture nativeTexture13 = (NativeTexture)NativeObjectFactory.getInstance().createTexture();
        TextureDescriptor textureDescriptor13 = (TextureDescriptor)nativeTexture13.getDescriptor();
        textureDescriptor13.setName("Solar_Panel");
        string = "/res/textures/rover/Solar_Panel.png";
        try {
            textureDescriptor13.setSource(Source.open("Solar_Panel_Textur_Source", new URI("file:///" + System.getProperty("user.dir").replaceAll("\\\\", "/") + string), Source.Type.PNGFile));
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        this.roverTextures.add(nativeTexture13);
        NativeTexture nativeTexture14 = (NativeTexture)NativeObjectFactory.getInstance().createTexture();
        TextureDescriptor textureDescriptor14 = (TextureDescriptor)nativeTexture14.getDescriptor();
        textureDescriptor14.setName("Rubber");
        string = "/res/textures/rover/Rubber.png";
        try {
            textureDescriptor14.setSource(Source.open("Rubber_Textur_Source", new URI("file:///" + System.getProperty("user.dir").replaceAll("\\\\", "/") + string), Source.Type.PNGFile));
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        this.roverTextures.add(nativeTexture14);
        assetLoader.load(this.roverTextures);
        for (Asset asset : this.roverTextures) {
            ((NativeTexture)asset).bind();
            ((NativeTexture)asset).buffer();
            ((NativeTexture)asset).unbind();
        }
    }
}

