/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.simulator;

import de.ti2010.mars.assets.core.Mesh;
import de.ti2010.mars.assets.core.VertexBuffer;
import de.ti2010.mars.assets.io.AssetLoader;
import de.ti2010.mars.assets.io.MeshDescriptor;
import de.ti2010.mars.assets.io.TextureDescriptor;
import de.ti2010.mars.gfx.core.NativeMesh;
import de.ti2010.mars.gfx.core.NativeTexture;
import de.ti2010.mars.gfx.core.NativeVertexBuffer;
import de.ti2010.mars.gfx.core.impl.NativeObjectFactory;
import de.ti2010.mars.io.Source;
import de.ti2010.mars.physics.core.AbstractElementFactory;
import de.ti2010.mars.physics.core.StoneElement;
import de.ti2010.mars.physics.core.WorldElement;
import de.ti2010.mars.physics.jbullet.JBulletAbstractBasicElementRepresentation;
import de.ti2010.mars.scene.GeometryNode;
import de.ti2010.mars.scene.Node;
import de.ti2010.mars.simulator.PhysicsEntity;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.vecmath.Vector3f;

public class Stone
implements PhysicsEntity {
    private String filepath = "/res/models/primitives/Quad.blend";
    private String textpath = "/res/textures/compCube.png";
    private Node stoneNode = null;
    private StoneElement gse = null;
    private IntBuffer indicesBuffer = null;
    private FloatBuffer positionVerticesBuffer = null;

    public Node buildStone() {
        this.buildMesh();
        this.buildTexture();
        this.buildPhysicsElement();
        return this.stoneNode;
    }

    private void buildMesh() {
        this.stoneNode = new GeometryNode("Stone");
        Source source = null;
        try {
            source = Source.open("", new URI("file:///" + System.getProperty("user.dir").replaceAll("\\\\", "/") + this.filepath), Source.Type.BlenderFile);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        NativeMesh nativeMesh = (NativeMesh)NativeObjectFactory.getInstance().createMesh();
        MeshDescriptor meshDescriptor = (MeshDescriptor)nativeMesh.getDescriptor();
        meshDescriptor.setSource(source);
        meshDescriptor.setName("Quad");
        meshDescriptor.setMode(Mesh.Mode.Triangles);
        AssetLoader assetLoader = AssetLoader.getInstance();
        assetLoader.load(nativeMesh);
        nativeMesh.bind();
        NativeVertexBuffer nativeVertexBuffer = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Position);
        nativeVertexBuffer.buffer();
        this.positionVerticesBuffer = (FloatBuffer)nativeVertexBuffer.getData();
        FloatBuffer floatBuffer = ByteBuffer.allocate(nativeVertexBuffer.getElements() << 2).asFloatBuffer();
        while (floatBuffer.position() < floatBuffer.capacity()) {
            floatBuffer.put(0.2f);
            floatBuffer.put(0.2f);
            floatBuffer.put(0.2f);
            floatBuffer.put(1.0f);
        }
        floatBuffer.flip();
        NativeVertexBuffer nativeVertexBuffer2 = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Color);
        nativeVertexBuffer2.initialize(VertexBuffer.Format.Float, VertexBuffer.Type.Color, VertexBuffer.Usage.Static, 4, floatBuffer);
        nativeVertexBuffer2.buffer();
        NativeVertexBuffer nativeVertexBuffer3 = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Index);
        nativeVertexBuffer3.buffer();
        this.indicesBuffer = (IntBuffer)nativeVertexBuffer3.getData();
        NativeVertexBuffer nativeVertexBuffer4 = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.TexturCoordinate);
        nativeVertexBuffer4.buffer();
        nativeMesh.unbind();
        ((GeometryNode)this.stoneNode).setMesh(nativeMesh);
    }

    private void buildTexture() {
        NativeTexture nativeTexture = (NativeTexture)NativeObjectFactory.getInstance().createTexture();
        TextureDescriptor textureDescriptor = (TextureDescriptor)nativeTexture.getDescriptor();
        textureDescriptor.setName("ntex");
        try {
            textureDescriptor.setSource(Source.open("", new URI("file:///" + System.getProperty("user.dir").replaceAll("\\\\", "/") + this.textpath), Source.Type.PNGFile));
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        AssetLoader.getInstance().load(nativeTexture);
        nativeTexture.bind();
        nativeTexture.buffer();
        ((GeometryNode)this.stoneNode).setTexture(nativeTexture);
    }

    private void buildPhysicsElement() {
        this.gse = AbstractElementFactory.getInstance().createGenericStoneElement(this);
    }

    @Override
    public void updateChanged() {
        this.stoneNode.setRelativeRotation(((JBulletAbstractBasicElementRepresentation)((Object)this.gse)).getRotationMatrix());
        this.stoneNode.setRelativeTranslation(((JBulletAbstractBasicElementRepresentation)((Object)this.gse)).getTranslationMatrix());
    }

    @Override
    public WorldElement getPhysicalElement() {
        return this.gse;
    }

    @Override
    public FloatBuffer getVertexPositions() {
        return this.positionVerticesBuffer;
    }

    @Override
    public IntBuffer getVertexPositionIndices() {
        return this.indicesBuffer;
    }

    public void setPosition(Vector3f vector3f) {
        this.gse.setPosition(vector3f);
    }
}

