/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.simulator.assets;

import de.ti2010.mars.assets.core.Mesh;
import de.ti2010.mars.assets.core.VertexBuffer;
import de.ti2010.mars.assets.io.AssetLoader;
import de.ti2010.mars.assets.io.TextureDescriptor;
import de.ti2010.mars.gfx.core.NativeMesh;
import de.ti2010.mars.gfx.core.NativeTexture;
import de.ti2010.mars.gfx.core.NativeVertexBuffer;
import de.ti2010.mars.gfx.core.impl.NativeObjectFactory;
import de.ti2010.mars.io.Source;
import de.ti2010.mars.scene.GeometryNode;
import de.ti2010.mars.scene.GroupNode;
import de.ti2010.mars.scene.Node;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;

public class Skybox {
    private NativeVertexBuffer nVertexBufferPositions = null;
    private NativeVertexBuffer nVertexBufferColors = null;
    private NativeVertexBuffer nVertexBufferIndices = null;
    private NativeVertexBuffer nVertexBufferst = null;
    private FloatBuffer bufferLines = null;
    private GroupNode Skybox;
    private Node skyNode0;
    private Node skyNode1;
    private Node skyNode2;
    private Node skyNode3;
    private Node skyNode4;
    private float dim = 1000.0f;
    private float off_y = 200.0f;
    private float c_off = 2.0f;
    private float[] color = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f};
    private float[] vertices0 = new float[]{-this.dim - this.c_off, this.dim + this.off_y, -this.dim, 1.0f, -this.dim - this.c_off, -this.dim + this.off_y, -this.dim, 1.0f, this.dim + this.c_off, -this.dim + this.off_y, -this.dim, 1.0f, this.dim + this.c_off, this.dim + this.off_y, -this.dim, 1.0f};
    private float[] vertices1 = new float[]{-this.dim, this.dim + this.off_y, this.dim + this.c_off, 1.0f, -this.dim, -this.dim + this.off_y, this.dim + this.c_off, 1.0f, -this.dim, -this.dim + this.off_y, -this.dim - this.c_off, 1.0f, -this.dim, this.dim + this.off_y, -this.dim - this.c_off, 1.0f};
    private float[] vertices2 = new float[]{this.dim + this.c_off, this.dim + this.off_y, this.dim, 1.0f, this.dim + this.c_off, -this.dim + this.off_y, this.dim, 1.0f, -this.dim - this.c_off, -this.dim + this.off_y, this.dim, 1.0f, -this.dim - this.c_off, this.dim + this.off_y, this.dim, 1.0f};
    private float[] vertices3 = new float[]{this.dim, this.dim + this.off_y, -this.dim - this.c_off, 1.0f, this.dim, -this.dim + this.off_y, -this.dim - this.c_off, 1.0f, this.dim, -this.dim + this.off_y, this.dim + this.c_off, 1.0f, this.dim, this.dim + this.off_y, this.dim + this.c_off, 1.0f};
    private float[] vertices4 = new float[]{-this.dim - this.c_off, this.dim + this.off_y - this.c_off, -this.dim - this.c_off, 1.0f, this.dim + this.c_off, this.dim + this.off_y - this.c_off, -this.dim - this.c_off, 1.0f, this.dim + this.c_off, this.dim + this.off_y - this.c_off, this.dim + this.c_off, 1.0f, -this.dim - this.c_off, this.dim + this.off_y - this.c_off, this.dim + this.c_off, 1.0f};
    private float[] st = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f};
    private int[] indices = new int[]{0, 1, 2, 2, 3, 0};

    public Node buildSky() {
        this.Skybox = new GroupNode();
        this.Skybox.add(this.buildSky0());
        this.Skybox.add(this.buildSky1());
        this.Skybox.add(this.buildSky2());
        this.Skybox.add(this.buildSky3());
        this.Skybox.add(this.buildSky4());
        return this.Skybox;
    }

    private Node buildSky0() {
        this.createHorizont0();
        this.buildTexture(this.skyNode0, "right90");
        return this.skyNode0;
    }

    private Node buildSky1() {
        this.createHorizont1();
        this.buildTexture(this.skyNode1, "front0");
        return this.skyNode1;
    }

    private Node buildSky2() {
        this.createHorizont2();
        this.buildTexture(this.skyNode2, "left270");
        return this.skyNode2;
    }

    private Node buildSky3() {
        this.createHorizont3();
        this.buildTexture(this.skyNode3, "back180");
        return this.skyNode3;
    }

    private Node buildSky4() {
        this.createHorizont4();
        this.buildTexture(this.skyNode4, "top0");
        return this.skyNode4;
    }

    private void createHorizont0() {
        this.skyNode0 = new GeometryNode("Sky");
        this.bufferLines = ByteBuffer.allocate(this.vertices0.length * 4).asFloatBuffer().put(this.vertices0);
        this.bufferLines.flip();
        FloatBuffer floatBuffer = ByteBuffer.allocate(this.color.length * 4).asFloatBuffer().put(this.color);
        floatBuffer.flip();
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)this.indices.length).put(this.indices);
        intBuffer.flip();
        FloatBuffer floatBuffer2 = ByteBuffer.allocate(this.st.length * 4).asFloatBuffer().put(this.st);
        floatBuffer2.flip();
        NativeMesh nativeMesh = (NativeMesh)NativeObjectFactory.getInstance().createMesh();
        nativeMesh.initialize(Mesh.Mode.Triangles);
        nativeMesh.bind();
        this.nVertexBufferPositions = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Position);
        this.nVertexBufferPositions.initialize(VertexBuffer.Format.Float, VertexBuffer.Type.Position, VertexBuffer.Usage.Static, 4, this.bufferLines);
        this.nVertexBufferPositions.buffer();
        this.nVertexBufferColors = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Color);
        this.nVertexBufferColors.initialize(VertexBuffer.Format.Float, VertexBuffer.Type.Color, VertexBuffer.Usage.Static, 4, floatBuffer);
        this.nVertexBufferColors.buffer();
        this.nVertexBufferIndices = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Index);
        this.nVertexBufferIndices.initialize(VertexBuffer.Format.Integer, VertexBuffer.Type.Index, VertexBuffer.Usage.Static, 3, intBuffer);
        this.nVertexBufferIndices.buffer();
        this.nVertexBufferst = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.TexturCoordinate);
        this.nVertexBufferst.initialize(VertexBuffer.Format.Float, VertexBuffer.Type.TexturCoordinate, VertexBuffer.Usage.Static, 2, floatBuffer2);
        this.nVertexBufferst.buffer();
        nativeMesh.unbind();
        ((GeometryNode)this.skyNode0).setMesh(nativeMesh);
    }

    private void createHorizont1() {
        this.skyNode1 = new GeometryNode("Sky");
        this.bufferLines = ByteBuffer.allocate(this.vertices1.length * 4).asFloatBuffer().put(this.vertices1);
        this.bufferLines.flip();
        FloatBuffer floatBuffer = ByteBuffer.allocate(this.color.length * 4).asFloatBuffer().put(this.color);
        floatBuffer.flip();
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)this.indices.length).put(this.indices);
        intBuffer.flip();
        FloatBuffer floatBuffer2 = ByteBuffer.allocate(this.st.length * 4).asFloatBuffer().put(this.st);
        floatBuffer2.flip();
        NativeMesh nativeMesh = (NativeMesh)NativeObjectFactory.getInstance().createMesh();
        nativeMesh.initialize(Mesh.Mode.Triangles);
        nativeMesh.bind();
        this.nVertexBufferPositions = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Position);
        this.nVertexBufferPositions.initialize(VertexBuffer.Format.Float, VertexBuffer.Type.Position, VertexBuffer.Usage.Static, 4, this.bufferLines);
        this.nVertexBufferPositions.buffer();
        this.nVertexBufferColors = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Color);
        this.nVertexBufferColors.initialize(VertexBuffer.Format.Float, VertexBuffer.Type.Color, VertexBuffer.Usage.Static, 4, floatBuffer);
        this.nVertexBufferColors.buffer();
        this.nVertexBufferIndices = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Index);
        this.nVertexBufferIndices.initialize(VertexBuffer.Format.Integer, VertexBuffer.Type.Index, VertexBuffer.Usage.Static, 3, intBuffer);
        this.nVertexBufferIndices.buffer();
        this.nVertexBufferst = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.TexturCoordinate);
        this.nVertexBufferst.initialize(VertexBuffer.Format.Float, VertexBuffer.Type.TexturCoordinate, VertexBuffer.Usage.Static, 2, floatBuffer2);
        this.nVertexBufferst.buffer();
        nativeMesh.unbind();
        ((GeometryNode)this.skyNode1).setMesh(nativeMesh);
    }

    private void createHorizont2() {
        this.skyNode2 = new GeometryNode("Sky");
        this.bufferLines = ByteBuffer.allocate(this.vertices2.length * 4).asFloatBuffer().put(this.vertices2);
        this.bufferLines.flip();
        FloatBuffer floatBuffer = ByteBuffer.allocate(this.color.length * 4).asFloatBuffer().put(this.color);
        floatBuffer.flip();
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)this.indices.length).put(this.indices);
        intBuffer.flip();
        FloatBuffer floatBuffer2 = ByteBuffer.allocate(this.st.length * 4).asFloatBuffer().put(this.st);
        floatBuffer2.flip();
        NativeMesh nativeMesh = (NativeMesh)NativeObjectFactory.getInstance().createMesh();
        nativeMesh.initialize(Mesh.Mode.Triangles);
        nativeMesh.bind();
        this.nVertexBufferPositions = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Position);
        this.nVertexBufferPositions.initialize(VertexBuffer.Format.Float, VertexBuffer.Type.Position, VertexBuffer.Usage.Static, 4, this.bufferLines);
        this.nVertexBufferPositions.buffer();
        this.nVertexBufferColors = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Color);
        this.nVertexBufferColors.initialize(VertexBuffer.Format.Float, VertexBuffer.Type.Color, VertexBuffer.Usage.Static, 4, floatBuffer);
        this.nVertexBufferColors.buffer();
        this.nVertexBufferIndices = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Index);
        this.nVertexBufferIndices.initialize(VertexBuffer.Format.Integer, VertexBuffer.Type.Index, VertexBuffer.Usage.Static, 3, intBuffer);
        this.nVertexBufferIndices.buffer();
        this.nVertexBufferst = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.TexturCoordinate);
        this.nVertexBufferst.initialize(VertexBuffer.Format.Float, VertexBuffer.Type.TexturCoordinate, VertexBuffer.Usage.Static, 2, floatBuffer2);
        this.nVertexBufferst.buffer();
        nativeMesh.unbind();
        ((GeometryNode)this.skyNode2).setMesh(nativeMesh);
    }

    private void createHorizont3() {
        this.skyNode3 = new GeometryNode("Sky");
        this.bufferLines = ByteBuffer.allocate(this.vertices3.length * 4).asFloatBuffer().put(this.vertices3);
        this.bufferLines.flip();
        FloatBuffer floatBuffer = ByteBuffer.allocate(this.color.length * 4).asFloatBuffer().put(this.color);
        floatBuffer.flip();
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)this.indices.length).put(this.indices);
        intBuffer.flip();
        FloatBuffer floatBuffer2 = ByteBuffer.allocate(this.st.length * 4).asFloatBuffer().put(this.st);
        floatBuffer2.flip();
        NativeMesh nativeMesh = (NativeMesh)NativeObjectFactory.getInstance().createMesh();
        nativeMesh.initialize(Mesh.Mode.Triangles);
        nativeMesh.bind();
        this.nVertexBufferPositions = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Position);
        this.nVertexBufferPositions.initialize(VertexBuffer.Format.Float, VertexBuffer.Type.Position, VertexBuffer.Usage.Static, 4, this.bufferLines);
        this.nVertexBufferPositions.buffer();
        this.nVertexBufferColors = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Color);
        this.nVertexBufferColors.initialize(VertexBuffer.Format.Float, VertexBuffer.Type.Color, VertexBuffer.Usage.Static, 4, floatBuffer);
        this.nVertexBufferColors.buffer();
        this.nVertexBufferIndices = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Index);
        this.nVertexBufferIndices.initialize(VertexBuffer.Format.Integer, VertexBuffer.Type.Index, VertexBuffer.Usage.Static, 3, intBuffer);
        this.nVertexBufferIndices.buffer();
        this.nVertexBufferst = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.TexturCoordinate);
        this.nVertexBufferst.initialize(VertexBuffer.Format.Float, VertexBuffer.Type.TexturCoordinate, VertexBuffer.Usage.Static, 2, floatBuffer2);
        this.nVertexBufferst.buffer();
        nativeMesh.unbind();
        ((GeometryNode)this.skyNode3).setMesh(nativeMesh);
    }

    private void createHorizont4() {
        this.skyNode4 = new GeometryNode("Sky");
        this.bufferLines = ByteBuffer.allocate(this.vertices4.length * 4).asFloatBuffer().put(this.vertices4);
        this.bufferLines.flip();
        FloatBuffer floatBuffer = ByteBuffer.allocate(this.color.length * 4).asFloatBuffer().put(this.color);
        floatBuffer.flip();
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)this.indices.length).put(this.indices);
        intBuffer.flip();
        FloatBuffer floatBuffer2 = ByteBuffer.allocate(this.st.length * 4).asFloatBuffer().put(this.st);
        floatBuffer2.flip();
        NativeMesh nativeMesh = (NativeMesh)NativeObjectFactory.getInstance().createMesh();
        nativeMesh.initialize(Mesh.Mode.Triangles);
        nativeMesh.bind();
        this.nVertexBufferPositions = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Position);
        this.nVertexBufferPositions.initialize(VertexBuffer.Format.Float, VertexBuffer.Type.Position, VertexBuffer.Usage.Static, 4, this.bufferLines);
        this.nVertexBufferPositions.buffer();
        this.nVertexBufferColors = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Color);
        this.nVertexBufferColors.initialize(VertexBuffer.Format.Float, VertexBuffer.Type.Color, VertexBuffer.Usage.Static, 4, floatBuffer);
        this.nVertexBufferColors.buffer();
        this.nVertexBufferIndices = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.Index);
        this.nVertexBufferIndices.initialize(VertexBuffer.Format.Integer, VertexBuffer.Type.Index, VertexBuffer.Usage.Static, 3, intBuffer);
        this.nVertexBufferIndices.buffer();
        this.nVertexBufferst = (NativeVertexBuffer)nativeMesh.getVertexBuffer(VertexBuffer.Type.TexturCoordinate);
        this.nVertexBufferst.initialize(VertexBuffer.Format.Float, VertexBuffer.Type.TexturCoordinate, VertexBuffer.Usage.Static, 2, floatBuffer2);
        this.nVertexBufferst.buffer();
        nativeMesh.unbind();
        ((GeometryNode)this.skyNode4).setMesh(nativeMesh);
    }

    private void buildTexture(Node node, String string) {
        NativeTexture nativeTexture = (NativeTexture)NativeObjectFactory.getInstance().createTexture();
        TextureDescriptor textureDescriptor = (TextureDescriptor)nativeTexture.getDescriptor();
        textureDescriptor.setName("skytex");
        try {
            textureDescriptor.setSource(Source.open("", new URI("file:///" + System.getProperty("user.dir").replaceAll("\\\\", "/") + "/res/textures/skybox/" + string + ".png"), Source.Type.PNGFile));
        }
        catch (URISyntaxException uRISyntaxException) {
            System.out.println("Error in creating a Sky.");
            uRISyntaxException.printStackTrace();
        }
        AssetLoader.getInstance().load(nativeTexture);
        nativeTexture.bind();
        nativeTexture.buffer();
        ((GeometryNode)node).setTexture(nativeTexture);
    }
}

