/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.ui;

import de.ti2010.mars.ui.UITextComponent;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class UIMultiLineLabel
extends UITextComponent {
    private String[] lines = null;
    private boolean isMultipleLinesEnable = false;
    private String lbRegex = null;

    @Override
    public void setText(String string) {
        this.text = string;
        if (this.isMultipleLinesEnable) {
            if (this.lbRegex == null) {
                this.lbRegex = "\n|\r";
            }
            this.lines = string.split(this.lbRegex);
        } else {
            this.lines = new String[1];
            this.lines[0] = string;
        }
    }

    public String getLineBreakRegularExpression() {
        return this.lbRegex;
    }

    public void setLineBreakRegularExpression(String string) {
        this.lbRegex = string;
    }

    public void setMultipleLinesEnable(boolean bl) {
        boolean bl2 = bl != this.isMultipleLinesEnable;
        this.isMultipleLinesEnable = bl;
        if (bl2) {
            this.setText(this.text);
        }
    }

    public boolean isMultipleLinesEnable() {
        return this.isMultipleLinesEnable;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.isVisible()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setFont(this.font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            graphics2D.setColor(this.background);
            graphics2D.fillRect(0, 0, this.width, this.height);
            int n = (this.lines.length - 1) * (fontMetrics.getHeight() + fontMetrics.getLeading()) + fontMetrics.getDescent();
            int n2 = 0;
            switch (this.verticalTextAlign) {
                case Bottom: {
                    n2 = this.height - n;
                    break;
                }
                case Middle: {
                    n2 = Math.round((this.height - n) / 2);
                    break;
                }
                case Top: {
                    n2 = fontMetrics.getHeight();
                }
            }
            graphics2D.setColor(this.foreground);
            for (int i = 0; i < this.lines.length; ++i) {
                String string = this.lines[i];
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
                int n3 = this.horizontalTextAlign.location(this.width, rectangle2D.getWidth());
                int n4 = n2 + (fontMetrics.getHeight() + fontMetrics.getLeading()) * i;
                graphics2D.drawString(string, n3, n4);
            }
        }
    }
}

