/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.renderer.AnimationState;

public class AnimationState
implements de.matthiasmann.twl.renderer.AnimationState {
    private final AnimationState parent;
    private State[] stateTable;
    private GUI gui;

    public AnimationState(AnimationState parent, int size) {
        this.parent = parent;
        this.stateTable = new State[size];
    }

    public AnimationState(AnimationState parent) {
        this(parent, 16);
    }

    public AnimationState() {
        this(null);
    }

    public void setGUI(GUI gui) {
        this.gui = gui;
        long curTime = this.getCurrentTime();
        for (State s : this.stateTable) {
            if (s == null) continue;
            s.lastChangedTime = curTime;
        }
    }

    public int getAnimationTime(AnimationState.StateKey stateKey) {
        State state = this.getState(stateKey);
        if (state != null) {
            return (int)Math.min(Integer.MAX_VALUE, this.getCurrentTime() - state.lastChangedTime);
        }
        if (this.parent != null) {
            return this.parent.getAnimationTime(stateKey);
        }
        return (int)this.getCurrentTime() & Integer.MAX_VALUE;
    }

    public boolean getAnimationState(AnimationState.StateKey stateKey) {
        State state = this.getState(stateKey);
        if (state != null) {
            return state.active;
        }
        if (this.parent != null) {
            return this.parent.getAnimationState(stateKey);
        }
        return false;
    }

    public boolean getShouldAnimateState(AnimationState.StateKey stateKey) {
        State state = this.getState(stateKey);
        if (state != null) {
            return state.shouldAnimate;
        }
        if (this.parent != null) {
            return this.parent.getShouldAnimateState(stateKey);
        }
        return false;
    }

    @Deprecated
    public void setAnimationState(String stateName, boolean active) {
        this.setAnimationState(AnimationState.StateKey.get(stateName), active);
    }

    public void setAnimationState(AnimationState.StateKey stateKey, boolean active) {
        State state = this.getOrCreate(stateKey);
        if (state.active != active) {
            state.active = active;
            state.lastChangedTime = this.getCurrentTime();
            state.shouldAnimate = true;
        }
    }

    @Deprecated
    public void resetAnimationTime(String stateName) {
        this.resetAnimationTime(AnimationState.StateKey.get(stateName));
    }

    public void resetAnimationTime(AnimationState.StateKey stateKey) {
        State state = this.getOrCreate(stateKey);
        state.lastChangedTime = this.getCurrentTime();
        state.shouldAnimate = true;
    }

    @Deprecated
    public void dontAnimate(String stateName) {
        this.dontAnimate(AnimationState.StateKey.get(stateName));
    }

    public void dontAnimate(AnimationState.StateKey stateKey) {
        State state = this.getState(stateKey);
        if (state != null) {
            state.shouldAnimate = false;
        }
    }

    private State getState(AnimationState.StateKey stateKey) {
        int id = stateKey.getID();
        if (id < this.stateTable.length) {
            return this.stateTable[id];
        }
        return null;
    }

    private State getOrCreate(AnimationState.StateKey stateKey) {
        State state;
        int id = stateKey.getID();
        if (id < this.stateTable.length && (state = this.stateTable[id]) != null) {
            return state;
        }
        return this.createState(id);
    }

    private State createState(int id) {
        if (id >= this.stateTable.length) {
            State[] newTable = new State[id + 1];
            System.arraycopy(this.stateTable, 0, newTable, 0, this.stateTable.length);
            this.stateTable = newTable;
        }
        State state = new State();
        state.lastChangedTime = this.getCurrentTime();
        this.stateTable[id] = state;
        return state;
    }

    private long getCurrentTime() {
        return this.gui != null ? this.gui.curTime : 0L;
    }

    static final class State {
        long lastChangedTime;
        boolean active;
        boolean shouldAnimate;

        State() {
        }
    }
}

