/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import java.util.EnumMap;

public class BorderLayout
extends Widget {
    private final EnumMap<Location, Widget> widgets = new EnumMap(Location.class);
    private int hgap;
    private int vgap;

    public void add(Widget widget, Location location) {
        if (widget == null) {
            throw new NullPointerException("widget is null");
        }
        if (location == null) {
            throw new NullPointerException("location is null");
        }
        if (this.widgets.containsKey((Object)location)) {
            throw new IllegalStateException("a widget was already added to that location: " + (Object)((Object)location));
        }
        this.widgets.put(location, widget);
        try {
            super.insertChild(widget, this.getNumChildren());
        }
        catch (Exception e) {
            this.removeChild(location);
        }
    }

    public Widget getChild(Location location) {
        if (location == null) {
            throw new NullPointerException("location is null");
        }
        return this.widgets.get((Object)location);
    }

    public Widget removeChild(Location location) {
        if (location == null) {
            throw new NullPointerException("location is null");
        }
        Widget w = this.widgets.remove((Object)location);
        if (w != null) {
            this.removeChild(w);
        }
        return w;
    }

    public void add(Widget child) {
        this.add(child, Location.CENTER);
    }

    public void insertChild(Widget child, int index) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("insert child is not supported by the BorderLayout");
    }

    protected void childRemoved(Widget exChild) {
        for (Location loc : this.widgets.keySet()) {
            if (this.widgets.get((Object)loc) != exChild) continue;
            this.widgets.remove((Object)loc);
            break;
        }
        super.childRemoved(exChild);
    }

    protected void allChildrenRemoved() {
        this.widgets.clear();
        super.allChildrenRemoved();
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        this.hgap = themeInfo.getParameter("hgap", 0);
        this.vgap = themeInfo.getParameter("vgap", 0);
        super.applyTheme(themeInfo);
    }

    protected void layout() {
        int top = this.getInnerY();
        int bottom = this.getInnerBottom();
        int left = this.getInnerX();
        int right = this.getInnerRight();
        Widget w = this.widgets.get((Object)Location.NORTH);
        if (w != null) {
            w.setPosition(left, top);
            w.setSize(Math.max(right - left, 0), Math.max(w.getPreferredHeight(), 0));
            top += w.getPreferredHeight() + this.vgap;
        }
        if ((w = this.widgets.get((Object)Location.SOUTH)) != null) {
            w.setPosition(left, bottom - w.getPreferredHeight());
            w.setSize(Math.max(right - left, 0), Math.max(w.getPreferredHeight(), 0));
            bottom -= w.getPreferredHeight() + this.vgap;
        }
        if ((w = this.widgets.get((Object)Location.EAST)) != null) {
            w.setPosition(right - w.getPreferredWidth(), top);
            w.setSize(Math.max(w.getPreferredWidth(), 0), Math.max(bottom - top, 0));
            right -= w.getPreferredWidth() + this.hgap;
        }
        if ((w = this.widgets.get((Object)Location.WEST)) != null) {
            w.setPosition(left, top);
            w.setSize(Math.max(w.getPreferredWidth(), 0), Math.max(bottom - top, 0));
            left += w.getPreferredWidth() + this.hgap;
        }
        if ((w = this.widgets.get((Object)Location.CENTER)) != null) {
            w.setPosition(left, top);
            w.setSize(Math.max(right - left, 0), Math.max(bottom - top, 0));
        }
    }

    public int getMinWidth() {
        return this.computeMinWidth();
    }

    public int getMinHeight() {
        return this.computeMinHeight();
    }

    public int getPreferredInnerWidth() {
        return this.computePrefWidth();
    }

    public int getPreferredInnerHeight() {
        return this.computePrefHeight();
    }

    private int computeMinWidth() {
        int size = 0;
        size += this.getChildMinWidth(this.widgets.get((Object)Location.EAST), this.hgap);
        size += this.getChildMinWidth(this.widgets.get((Object)Location.WEST), this.hgap);
        size += this.getChildMinWidth(this.widgets.get((Object)Location.CENTER), 0);
        size = Math.max(size, this.getChildMinWidth(this.widgets.get((Object)Location.NORTH), 0));
        size = Math.max(size, this.getChildMinWidth(this.widgets.get((Object)Location.SOUTH), 0));
        return size;
    }

    private int computeMinHeight() {
        int size = 0;
        size = Math.max(size, this.getChildMinHeight(this.widgets.get((Object)Location.EAST), 0));
        size = Math.max(size, this.getChildMinHeight(this.widgets.get((Object)Location.WEST), 0));
        size = Math.max(size, this.getChildMinHeight(this.widgets.get((Object)Location.CENTER), 0));
        size += this.getChildMinHeight(this.widgets.get((Object)Location.NORTH), this.vgap);
        return size += this.getChildMinHeight(this.widgets.get((Object)Location.SOUTH), this.vgap);
    }

    private int computePrefWidth() {
        int size = 0;
        size += this.getChildPrefWidth(this.widgets.get((Object)Location.EAST), this.hgap);
        size += this.getChildPrefWidth(this.widgets.get((Object)Location.WEST), this.hgap);
        size += this.getChildPrefWidth(this.widgets.get((Object)Location.CENTER), 0);
        size = Math.max(size, this.getChildPrefWidth(this.widgets.get((Object)Location.NORTH), 0));
        size = Math.max(size, this.getChildPrefWidth(this.widgets.get((Object)Location.SOUTH), 0));
        return size;
    }

    private int computePrefHeight() {
        int size = 0;
        size = Math.max(size, this.getChildPrefHeight(this.widgets.get((Object)Location.EAST), 0));
        size = Math.max(size, this.getChildPrefHeight(this.widgets.get((Object)Location.WEST), 0));
        size = Math.max(size, this.getChildPrefHeight(this.widgets.get((Object)Location.CENTER), 0));
        size += this.getChildPrefHeight(this.widgets.get((Object)Location.NORTH), this.vgap);
        return size += this.getChildPrefHeight(this.widgets.get((Object)Location.SOUTH), this.vgap);
    }

    private int getChildMinWidth(Widget w, int gap) {
        if (w != null) {
            return w.getMinWidth() + gap;
        }
        return 0;
    }

    private int getChildMinHeight(Widget w, int gap) {
        if (w != null) {
            return w.getMinHeight() + gap;
        }
        return 0;
    }

    private int getChildPrefWidth(Widget w, int gap) {
        if (w != null) {
            return BorderLayout.computeSize(w.getMinWidth(), w.getPreferredWidth(), w.getMaxWidth()) + gap;
        }
        return 0;
    }

    private int getChildPrefHeight(Widget w, int gap) {
        if (w != null) {
            return BorderLayout.computeSize(w.getMinHeight(), w.getPreferredHeight(), w.getMaxHeight()) + gap;
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Location {
        EAST,
        WEST,
        NORTH,
        SOUTH,
        CENTER;

    }
}

