/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.Alignment;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.MenuAction;
import de.matthiasmann.twl.MenuCheckbox;
import de.matthiasmann.twl.MenuElement;
import de.matthiasmann.twl.MenuManager;
import de.matthiasmann.twl.MenuSpacer;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.BooleanModel;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.utils.CallbackSupport;
import de.matthiasmann.twl.utils.TypeMapping;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Menu
extends MenuElement
implements Iterable<MenuElement> {
    public static final AnimationState.StateKey STATE_HAS_OPEN_MENUS = AnimationState.StateKey.get("hasOpenMenus");
    private final ArrayList<MenuElement> elements = new ArrayList();
    private final TypeMapping<Alignment> classAlignments = new TypeMapping();
    private String popupTheme;
    private Listener[] listeners;

    public Menu() {
    }

    public Menu(String name) {
        super(name);
    }

    public void addListener(Listener listener) {
        this.listeners = CallbackSupport.addCallbackToList(this.listeners, listener, Listener.class);
    }

    public void removeListener(Listener listener) {
        this.listeners = CallbackSupport.removeCallbackFromList(this.listeners, listener);
    }

    public String getPopupTheme() {
        return this.popupTheme;
    }

    public void setPopupTheme(String popupTheme) {
        String oldPopupTheme = this.popupTheme;
        this.popupTheme = popupTheme;
        this.firePropertyChange("popupTheme", oldPopupTheme, this.popupTheme);
    }

    public void setClassAlignment(Class<? extends MenuElement> clazz, Alignment value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (value == Alignment.FILL) {
            this.classAlignments.remove(clazz);
        } else {
            this.classAlignments.put(clazz, value);
        }
    }

    public Alignment getClassAlignment(Class<? extends MenuElement> clazz) {
        Alignment alignment = this.classAlignments.get(clazz);
        if (alignment == null) {
            return Alignment.FILL;
        }
        return alignment;
    }

    @Override
    public Iterator<MenuElement> iterator() {
        return this.elements.iterator();
    }

    public MenuElement get(int index) {
        return this.elements.get(index);
    }

    public int getNumElements() {
        return this.elements.size();
    }

    public void clear() {
        this.elements.clear();
    }

    public Menu add(MenuElement e) {
        this.elements.add(e);
        return this;
    }

    public Menu add(String name, Runnable cb) {
        return this.add(new MenuAction(name, cb));
    }

    public Menu add(String name, BooleanModel model) {
        return this.add(new MenuCheckbox(name, model));
    }

    public Menu addSpacer() {
        return this.add(new MenuSpacer());
    }

    public void createMenuBar(Widget container) {
        MenuManager mm = this.createMenuManager(container, true);
        for (Widget w : this.createWidgets(mm, 0)) {
            container.add(w);
        }
    }

    public Widget createMenuBar() {
        DialogLayout l = new DialogLayout();
        this.setWidgetTheme(l, "menubar");
        MenuManager mm = this.createMenuManager(l, true);
        Widget[] widgets = this.createWidgets(mm, 0);
        l.setHorizontalGroup(l.createSequentialGroup().addWidgetsWithGap("menuitem", widgets));
        l.setVerticalGroup(l.createParallelGroup(widgets));
        int n = this.elements.size();
        for (int i = 0; i < n; ++i) {
            MenuElement e = this.elements.get(i);
            Alignment alignment = e.getAlignment();
            if (alignment == null) {
                alignment = this.getClassAlignment(e.getClass());
            }
            l.setWidgetAlignment(widgets[i], alignment);
        }
        l.getHorizontalGroup().addGap();
        return l;
    }

    public MenuManager openPopupMenu(Widget parent) {
        MenuManager mm = this.createMenuManager(parent, false);
        mm.openSubMenu(0, this, parent, true);
        return mm;
    }

    public MenuManager openPopupMenu(Widget parent, int x, int y) {
        MenuManager mm = this.createMenuManager(parent, false);
        Widget popup = mm.openSubMenu(0, this, parent, false);
        if (popup != null) {
            popup.setPosition(x, y);
        }
        return mm;
    }

    @Override
    protected Widget createMenuWidget(MenuManager mm, int level) {
        SubMenuBtn smb = new SubMenuBtn(mm, level);
        this.setWidgetTheme(smb, "submenu");
        return smb;
    }

    protected MenuManager createMenuManager(Widget parent, boolean isMenuBar) {
        return new MenuManager(parent, isMenuBar);
    }

    protected Widget[] createWidgets(MenuManager mm, int level) {
        Widget[] widgets = new Widget[this.elements.size()];
        int n = this.elements.size();
        for (int i = 0; i < n; ++i) {
            MenuElement e = this.elements.get(i);
            widgets[i] = e.createMenuWidget(mm, level);
        }
        return widgets;
    }

    DialogLayout createPopup(MenuManager mm, int level, Widget btn) {
        if (this.listeners != null) {
            for (Listener l : this.listeners) {
                l.menuOpening(this);
            }
        }
        Widget[] widgets = this.createWidgets(mm, level);
        MenuPopup popup = new MenuPopup(btn, level, this);
        if (this.popupTheme != null) {
            popup.setTheme(this.popupTheme);
        }
        popup.setHorizontalGroup(popup.createParallelGroup(widgets));
        popup.setVerticalGroup(popup.createSequentialGroup().addWidgetsWithGap("menuitem", widgets));
        return popup;
    }

    void fireMenuOpened() {
        if (this.listeners != null) {
            for (Listener l : this.listeners) {
                l.menuOpened(this);
            }
        }
    }

    void fireMenuClosed() {
        if (this.listeners != null) {
            for (Listener l : this.listeners) {
                l.menuClosed(this);
            }
        }
    }

    class SubMenuBtn
    extends MenuElement.MenuBtn
    implements Runnable {
        private final MenuManager mm;
        private final int level;

        public SubMenuBtn(MenuManager mm, int level) {
            super(Menu.this);
            this.mm = mm;
            this.level = level;
            this.addCallback(this);
        }

        public void run() {
            this.mm.openSubMenu(this.level, Menu.this, this, true);
        }
    }

    static class MenuPopup
    extends DialogLayout {
        private final Widget btn;
        private final Menu menu;
        final int level;

        MenuPopup(Widget btn, int level, Menu menu) {
            this.btn = btn;
            this.menu = menu;
            this.level = level;
        }

        protected void afterAddToGUI(GUI gui) {
            super.afterAddToGUI(gui);
            this.menu.fireMenuOpened();
            this.btn.getAnimationState().setAnimationState(STATE_HAS_OPEN_MENUS, true);
        }

        protected void beforeRemoveFromGUI(GUI gui) {
            this.btn.getAnimationState().setAnimationState(STATE_HAS_OPEN_MENUS, false);
            this.menu.fireMenuClosed();
            super.beforeRemoveFromGUI(gui);
        }

        protected boolean handleEvent(Event evt) {
            return super.handleEvent(evt) || evt.isMouseEventNoWheel();
        }
    }

    public static interface Listener {
        public void menuOpening(Menu var1);

        public void menuOpened(Menu var1);

        public void menuClosed(Menu var1);
    }
}

