/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.renderer.lwjgl;

import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.Gradient;
import de.matthiasmann.twl.renderer.Image;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLRenderer;
import de.matthiasmann.twl.renderer.lwjgl.TintStack;
import org.lwjgl.opengl.GL11;

public class GradientImage
implements Image {
    private final LWJGLRenderer renderer;
    private final Gradient.Type type;
    private final Gradient.Wrap wrap;
    private final Gradient.Stop[] stops;
    private final Color tint;
    private final float endPos;

    GradientImage(GradientImage src, Color tint) {
        this.renderer = src.renderer;
        this.type = src.type;
        this.wrap = src.wrap;
        this.stops = src.stops;
        this.endPos = src.endPos;
        this.tint = tint;
    }

    public GradientImage(LWJGLRenderer renderer, Gradient gradient) {
        if (gradient == null) {
            throw new NullPointerException("gradient");
        }
        if (gradient.getNumStops() < 1) {
            throw new IllegalArgumentException("Need at least 1 stop for a gradient");
        }
        this.renderer = renderer;
        this.type = gradient.getType();
        this.tint = Color.WHITE;
        if (gradient.getNumStops() == 1) {
            Color color = gradient.getStop(0).getColor();
            this.wrap = Gradient.Wrap.SCALE;
            this.stops = new Gradient.Stop[]{new Gradient.Stop(0.0f, color), new Gradient.Stop(1.0f, color)};
            this.endPos = 1.0f;
        } else if (gradient.getWrap() == Gradient.Wrap.MIRROR) {
            int i;
            int numStops = gradient.getNumStops();
            this.wrap = Gradient.Wrap.REPEAT;
            this.stops = new Gradient.Stop[numStops * 2 - 1];
            for (i = 0; i < numStops; ++i) {
                this.stops[i] = gradient.getStop(i);
            }
            this.endPos = this.stops[numStops - 1].getPos() * 2.0f;
            i = numStops;
            for (int j = numStops - 2; j >= 0; --j) {
                this.stops[i] = new Gradient.Stop(this.endPos - this.stops[j].getPos(), this.stops[j].getColor());
                ++i;
            }
        } else {
            this.wrap = gradient.getWrap();
            this.stops = gradient.getStops();
            this.endPos = this.stops[this.stops.length - 1].getPos();
        }
    }

    public Image createTintedVersion(Color color) {
        return new GradientImage(this, this.tint.multiply(color));
    }

    private boolean isHorz() {
        return this.type == Gradient.Type.HORIZONTAL;
    }

    private int getLastPos() {
        return Math.round(this.stops[this.stops.length - 1].getPos());
    }

    public int getHeight() {
        return this.isHorz() ? 1 : this.getLastPos();
    }

    public int getWidth() {
        return this.isHorz() ? this.getLastPos() : 1;
    }

    public void draw(AnimationState as, int x, int y) {
        if (this.isHorz()) {
            this.drawHorz(x, y, this.getLastPos(), 1);
        } else {
            this.drawVert(x, y, 1, this.getLastPos());
        }
    }

    public void draw(AnimationState as, int x, int y, int width, int height) {
        if (this.isHorz()) {
            this.drawHorz(x, y, width, height);
        } else {
            this.drawVert(x, y, width, height);
        }
    }

    private void drawHorz(int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        TintStack tintStack = this.renderer.tintStack.push(this.tint);
        GL11.glDisable((int)3553);
        GL11.glBegin((int)8);
        if (this.wrap == Gradient.Wrap.SCALE) {
            for (Gradient.Stop stop : this.stops) {
                tintStack.setColor(stop.getColor());
                float pos = stop.getPos() * (float)width / this.endPos;
                GL11.glVertex2f((float)((float)x + pos), (float)y);
                GL11.glVertex2f((float)((float)x + pos), (float)(y + height));
            }
        } else {
            float lastPos = 0.0f;
            float offset = 0.0f;
            Color lastColor = this.stops[0].getColor();
            block1: do {
                for (Gradient.Stop stop : this.stops) {
                    float pos = stop.getPos() + offset;
                    Color color = stop.getColor();
                    if (pos >= (float)width) {
                        float t = ((float)width - lastPos) / (pos - lastPos);
                        GradientImage.setColor(tintStack, lastColor, color, t);
                        break block1;
                    }
                    tintStack.setColor(color);
                    GL11.glVertex2f((float)((float)x + pos), (float)y);
                    GL11.glVertex2f((float)((float)x + pos), (float)(y + height));
                    lastPos = pos;
                    lastColor = color;
                }
                offset += this.endPos;
            } while (this.wrap == Gradient.Wrap.REPEAT);
            GL11.glVertex2f((float)(x + width), (float)y);
            GL11.glVertex2f((float)(x + width), (float)(y + height));
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }

    private void drawVert(int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        TintStack tintStack = this.renderer.tintStack.push(this.tint);
        GL11.glDisable((int)3553);
        GL11.glBegin((int)8);
        if (this.wrap == Gradient.Wrap.SCALE) {
            for (Gradient.Stop stop : this.stops) {
                tintStack.setColor(stop.getColor());
                float pos = stop.getPos() * (float)height / this.endPos;
                GL11.glVertex2f((float)x, (float)((float)y + pos));
                GL11.glVertex2f((float)(x + width), (float)((float)y + pos));
            }
        } else {
            float lastPos = 0.0f;
            float offset = 0.0f;
            Color lastColor = this.stops[0].getColor();
            block1: do {
                for (Gradient.Stop stop : this.stops) {
                    float pos = stop.getPos() + offset;
                    Color color = stop.getColor();
                    if (pos >= (float)height) {
                        float t = ((float)height - lastPos) / (pos - lastPos);
                        GradientImage.setColor(tintStack, lastColor, color, t);
                        break block1;
                    }
                    tintStack.setColor(color);
                    GL11.glVertex2f((float)x, (float)((float)y + pos));
                    GL11.glVertex2f((float)(x + width), (float)((float)y + pos));
                    lastPos = pos;
                    lastColor = color;
                }
                offset += this.endPos;
            } while (this.wrap == Gradient.Wrap.REPEAT);
            GL11.glVertex2f((float)x, (float)(y + height));
            GL11.glVertex2f((float)(x + width), (float)(y + height));
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }

    private static void setColor(TintStack tintStack, Color a, Color b, float t) {
        tintStack.setColor(GradientImage.mix(a.getRed(), b.getRed(), t), GradientImage.mix(a.getGreen(), b.getGreen(), t), GradientImage.mix(a.getBlue(), b.getBlue(), t), GradientImage.mix(a.getAlpha(), b.getAlpha(), t));
    }

    private static float mix(int a, int b, float t) {
        return (float)a + (float)(b - a) * t;
    }
}

