/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.theme;

import java.io.IOException;
import java.net.URL;

public class ThemeException
extends IOException {
    protected final Source source;

    public ThemeException(String msg, URL url, int lineNumber, int columnNumber, Throwable cause) {
        super(msg);
        this.source = new Source(url, lineNumber, columnNumber);
        this.initCause(cause);
    }

    void addIncludedBy(URL url, int lineNumber, int columnNumber) {
        Source head = this.source;
        while (head.includedBy != null) {
            head = head.includedBy;
        }
        head.includedBy = new Source(url, lineNumber, columnNumber);
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder(super.getMessage());
        String prefix = "\n           in ";
        Source src = this.source;
        while (src != null) {
            sb.append(prefix).append(src.url).append(" @").append(src.lineNumber).append(':').append(src.columnNumber);
            prefix = "\n  included by ";
            src = src.includedBy;
        }
        return sb.toString();
    }

    public Source getSource() {
        return this.source;
    }

    public static final class Source {
        protected final URL url;
        protected final int lineNumber;
        protected final int columnNumber;
        protected Source includedBy;

        Source(URL url, int lineNumber, int columnNumber) {
            this.url = url;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
        }

        public URL getUrl() {
            return this.url;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public Source getIncludedBy() {
            return this.includedBy;
        }
    }
}

