/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.utils;

import de.matthiasmann.twl.CallbackWithReason;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallbackSupport {
    private CallbackSupport() {
    }

    private static void checkNotNull(Object callback) {
        if (callback == null) {
            throw new NullPointerException("callback");
        }
    }

    public static <T> T[] addCallbackToList(T[] curList, T callback, Class<T> clazz) {
        CallbackSupport.checkNotNull(callback);
        int curLength = curList == null ? 0 : curList.length;
        Object[] newList = (Object[])Array.newInstance(clazz, curLength + 1);
        if (curLength > 0) {
            System.arraycopy(curList, 0, newList, 0, curLength);
        }
        newList[curLength] = callback;
        return newList;
    }

    public static <T> int findCallbackPosition(T[] list, T callback) {
        CallbackSupport.checkNotNull(callback);
        if (list != null) {
            int n = list.length;
            for (int i = 0; i < n; ++i) {
                if (list[i] != callback) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> T[] removeCallbackFromList(T[] curList, int index) {
        int curLength = curList.length;
        assert (index >= 0 && index < curLength);
        if (curLength == 1) {
            return null;
        }
        int newLength = curLength - 1;
        Object[] newList = (Object[])Array.newInstance(curList.getClass().getComponentType(), newLength);
        System.arraycopy(curList, 0, newList, 0, index);
        System.arraycopy(curList, index + 1, newList, index, newLength - index);
        return newList;
    }

    public static <T> T[] removeCallbackFromList(T[] curList, T callback) {
        int idx = CallbackSupport.findCallbackPosition(curList, callback);
        if (idx >= 0) {
            curList = CallbackSupport.removeCallbackFromList(curList, idx);
        }
        return curList;
    }

    public static void fireCallbacks(Runnable[] callbacks) {
        if (callbacks != null) {
            for (Runnable cb : callbacks) {
                cb.run();
            }
        }
    }

    public static <T extends Enum<T>> void fireCallbacks(CallbackWithReason<?>[] callbacks, T reason) {
        if (callbacks != null) {
            for (CallbackWithReason<?> cb : callbacks) {
                cb.callback(reason);
            }
        }
    }
}

