/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.utils;

import de.matthiasmann.twl.renderer.AnimationState;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.BitSet;

public abstract class StateExpression {
    boolean negate;

    public abstract boolean evaluate(AnimationState var1);

    public static StateExpression parse(String exp, boolean negate) throws ParseException {
        StringIterator si = new StringIterator(exp);
        StateExpression expr = StateExpression.parse(si);
        if (si.hasMore()) {
            si.unexpected();
        }
        expr.negate ^= negate;
        return expr;
    }

    private static StateExpression parse(StringIterator si) throws ParseException {
        ArrayList<Check> children = new ArrayList<Check>();
        char kind = ' ';
        while (true) {
            char ch;
            boolean negate;
            if (!si.skipSpaces()) {
                si.unexpected();
            }
            boolean bl = negate = (ch = si.peek()) == '!';
            if (negate) {
                ++si.pos;
                if (!si.skipSpaces()) {
                    si.unexpected();
                }
                ch = si.peek();
            }
            StateExpression child = null;
            if (Character.isJavaIdentifierStart(ch)) {
                child = new Check(AnimationState.StateKey.get(si.getIdent()));
            } else if (ch == '(') {
                ++si.pos;
                child = StateExpression.parse(si);
                si.expect(')');
            } else {
                if (ch == ')') break;
                si.unexpected();
            }
            child.negate = negate;
            children.add((Check)child);
            if (!si.skipSpaces() || "|+^".indexOf(ch = si.peek()) < 0) break;
            if (children.size() == 1) {
                kind = ch;
            } else if (kind != ch) {
                si.expect(kind);
            }
            ++si.pos;
        }
        if (children.isEmpty()) {
            si.unexpected();
        }
        assert (kind != ' ' || children.size() == 1);
        if (children.size() == 1) {
            return (StateExpression)children.get(0);
        }
        return new Logic(kind, children.toArray(new StateExpression[children.size()]));
    }

    StateExpression() {
    }

    abstract void getUsedStateKeys(BitSet var1);

    public static class Check
    extends StateExpression {
        final AnimationState.StateKey state;

        public Check(AnimationState.StateKey state) {
            this.state = state;
        }

        public boolean evaluate(AnimationState as) {
            return this.negate ^ (as != null && as.getAnimationState(this.state));
        }

        void getUsedStateKeys(BitSet bs) {
            bs.set(this.state.getID());
        }
    }

    public static class Logic
    extends StateExpression {
        final StateExpression[] children;
        final boolean and;
        final boolean xor;

        public Logic(char kind, StateExpression ... children) {
            if (kind != '|' && kind != '+' && kind != '^') {
                throw new IllegalArgumentException("kind");
            }
            this.children = children;
            this.and = kind == '+';
            this.xor = kind == '^';
        }

        public boolean evaluate(AnimationState as) {
            boolean result = this.and ^ this.negate;
            for (StateExpression e : this.children) {
                boolean value = e.evaluate(as);
                if (this.xor) {
                    result ^= value;
                    continue;
                }
                if (this.and == value) continue;
                return result ^ true;
            }
            return result;
        }

        void getUsedStateKeys(BitSet bs) {
            for (StateExpression e : this.children) {
                e.getUsedStateKeys(bs);
            }
        }
    }

    private static class StringIterator {
        final String str;
        int pos;

        StringIterator(String str) {
            this.str = str;
        }

        boolean hasMore() {
            return this.pos < this.str.length();
        }

        char peek() {
            return this.str.charAt(this.pos);
        }

        void expect(char what) throws ParseException {
            if (!this.hasMore() || this.peek() != what) {
                throw new ParseException("Expected '" + what + "' got " + this.describePosition(), this.pos);
            }
            ++this.pos;
        }

        void unexpected() throws ParseException {
            throw new ParseException("Unexpected " + this.describePosition(), this.pos);
        }

        String describePosition() {
            if (this.pos >= this.str.length()) {
                return "end of expression";
            }
            return "'" + this.peek() + "' at " + (this.pos + 1);
        }

        boolean skipSpaces() {
            while (this.hasMore() && Character.isWhitespace(this.peek())) {
                ++this.pos;
            }
            return this.hasMore();
        }

        String getIdent() {
            int start = this.pos;
            while (this.hasMore() && Character.isJavaIdentifierPart(this.peek())) {
                ++this.pos;
            }
            return this.str.substring(start, this.pos).intern();
        }
    }
}

