/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.utils;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xmlpull.mxp1.MXParserCachingStrings;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLParser
implements Closeable {
    private static final Class<?>[] XPP_CLASS = new Class[]{XmlPullParser.class};
    private static boolean hasXMP1 = true;
    private final XmlPullParser xpp;
    private final String source;
    private final InputStream inputStream;
    private final BitSet unusedAttributes = new BitSet();
    private String loggerName = XMLParser.class.getName();

    public static XmlPullParser createParser() throws XmlPullParserException {
        if (hasXMP1) {
            try {
                MXParserCachingStrings xpp = new MXParserCachingStrings();
                xpp.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
                return xpp;
            }
            catch (Throwable ex) {
                hasXMP1 = false;
                Logger.getLogger(XMLParser.class.getName()).log(Level.WARNING, "Failed direct instantation", ex);
            }
        }
        return XPPF.newPullParser();
    }

    public XMLParser(XmlPullParser xpp, String source) {
        if (xpp == null) {
            throw new NullPointerException("xpp");
        }
        this.xpp = xpp;
        this.source = source;
        this.inputStream = null;
    }

    public XMLParser(URL url) throws XmlPullParserException, IOException {
        if (url == null) {
            throw new NullPointerException("url");
        }
        XmlPullParser xpp_ = null;
        InputStream is = null;
        this.source = url.toString();
        try {
            xpp_ = (XmlPullParser)url.getContent(XPP_CLASS);
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (xpp_ == null) {
            xpp_ = XMLParser.createParser();
            is = url.openStream();
            if (is == null) {
                throw new FileNotFoundException(this.source);
            }
            xpp_.setInput(is, "UTF8");
        }
        this.xpp = xpp_;
        this.inputStream = is;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public int next() throws XmlPullParserException, IOException {
        this.warnUnusedAttributes();
        int type = this.xpp.next();
        this.handleType(type);
        return type;
    }

    public int nextTag() throws XmlPullParserException, IOException {
        this.warnUnusedAttributes();
        int type = this.xpp.nextTag();
        this.handleType(type);
        return type;
    }

    public String nextText() throws XmlPullParserException, IOException {
        this.warnUnusedAttributes();
        return this.xpp.nextText();
    }

    public char[] nextText(int[] startAndLength) throws XmlPullParserException, IOException {
        int token;
        this.warnUnusedAttributes();
        block5: while (true) {
            token = this.xpp.nextToken();
            switch (token) {
                case 4: {
                    return this.xpp.getTextCharacters(startAndLength);
                }
                case 6: {
                    String replaced = this.xpp.getText();
                    startAndLength[0] = 0;
                    startAndLength[1] = replaced.length();
                    return replaced.toCharArray();
                }
                case 9: {
                    continue block5;
                }
            }
            break;
        }
        this.handleType(token);
        return null;
    }

    public void skipText() throws XmlPullParserException, IOException {
        int token = this.xpp.getEventType();
        while (token == 4 || token == 6 || token == 9) {
            token = this.xpp.nextToken();
        }
    }

    public boolean isStartTag() throws XmlPullParserException {
        return this.xpp.getEventType() == 2;
    }

    public boolean isEndTag() throws XmlPullParserException {
        return this.xpp.getEventType() == 3;
    }

    public String getPositionDescription() {
        String desc = this.xpp.getPositionDescription();
        if (this.source != null) {
            return desc + " in " + this.source;
        }
        return desc;
    }

    public int getLineNumber() {
        return this.xpp.getLineNumber();
    }

    public int getColumnNumber() {
        return this.xpp.getColumnNumber();
    }

    public String getName() {
        return this.xpp.getName();
    }

    public void require(int type, String namespace, String name) throws XmlPullParserException, IOException {
        this.xpp.require(type, namespace, name);
    }

    public String getAttributeValue(int index) {
        this.unusedAttributes.clear(index);
        return this.xpp.getAttributeValue(index);
    }

    public String getAttributeNamespace(int index) {
        return this.xpp.getAttributeNamespace(index);
    }

    public String getAttributeName(int index) {
        return this.xpp.getAttributeName(index);
    }

    public int getAttributeCount() {
        return this.xpp.getAttributeCount();
    }

    public String getAttributeValue(String namespace, String name) {
        int n = this.xpp.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            if (namespace != null && !namespace.equals(this.xpp.getAttributeNamespace(i)) || !name.equals(this.xpp.getAttributeName(i))) continue;
            return this.getAttributeValue(i);
        }
        return null;
    }

    public String getAttributeNotNull(String attribute) throws XmlPullParserException {
        String value = this.getAttributeValue(null, attribute);
        if (value == null) {
            this.missingAttribute(attribute);
        }
        return value;
    }

    public boolean parseBoolFromAttribute(String attribName) throws XmlPullParserException {
        return this.parseBool(this.getAttributeNotNull(attribName));
    }

    public boolean parseBoolFromText() throws XmlPullParserException, IOException {
        return this.parseBool(this.nextText());
    }

    public boolean parseBoolFromAttribute(String attribName, boolean defaultValue) throws XmlPullParserException {
        String value = this.getAttributeValue(null, attribName);
        if (value == null) {
            return defaultValue;
        }
        return this.parseBool(value);
    }

    public int parseIntFromAttribute(String attribName) throws XmlPullParserException {
        return this.parseInt(this.getAttributeNotNull(attribName));
    }

    public int parseIntFromAttribute(String attribName, int defaultValue) throws XmlPullParserException {
        String value = this.getAttributeValue(null, attribName);
        if (value == null) {
            return defaultValue;
        }
        return this.parseInt(value);
    }

    public float parseFloatFromAttribute(String attribName) throws XmlPullParserException {
        return this.parseFloat(this.getAttributeNotNull(attribName));
    }

    public float parseFloatFromAttribute(String attribName, float defaultValue) throws XmlPullParserException {
        String value = this.getAttributeValue(null, attribName);
        if (value == null) {
            return defaultValue;
        }
        return this.parseFloat(value);
    }

    public <E extends Enum<E>> E parseEnumFromAttribute(String attribName, Class<E> enumClazz) throws XmlPullParserException {
        return this.parseEnum(enumClazz, this.getAttributeNotNull(attribName));
    }

    public <E extends Enum<E>> E parseEnumFromAttribute(String attribName, Class<E> enumClazz, E defaultValue) throws XmlPullParserException {
        String value = this.getAttributeValue(null, attribName);
        if (value == null) {
            return defaultValue;
        }
        return this.parseEnum(enumClazz, value);
    }

    public <E extends Enum<E>> E parseEnumFromText(Class<E> enumClazz) throws XmlPullParserException, IOException {
        return this.parseEnum(enumClazz, this.nextText());
    }

    public Map<String, String> getUnusedAttributes() {
        if (this.unusedAttributes.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        int i = -1;
        while ((i = this.unusedAttributes.nextSetBit(i + 1)) >= 0) {
            result.put(this.xpp.getAttributeName(i), this.xpp.getAttributeValue(i));
        }
        this.unusedAttributes.clear();
        return result;
    }

    public void ignoreOtherAttributes() {
        this.unusedAttributes.clear();
    }

    public boolean isAttributeUnused(int idx) {
        return this.unusedAttributes.get(idx);
    }

    public XmlPullParserException error(String msg) {
        return new XmlPullParserException(msg, this.xpp, null);
    }

    public XmlPullParserException error(String msg, Throwable cause) {
        return (XmlPullParserException)new XmlPullParserException(msg, this.xpp, cause).initCause(cause);
    }

    public XmlPullParserException unexpected() {
        return new XmlPullParserException("Unexpected '" + this.xpp.getName() + "'", this.xpp, null);
    }

    protected <E extends Enum<E>> E parseEnum(Class<E> enumClazz, String value) throws XmlPullParserException {
        try {
            return Enum.valueOf(enumClazz, value.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException unused) {
            try {
                return Enum.valueOf(enumClazz, value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XmlPullParserException("Unknown enum value \"" + value + "\" for enum class " + enumClazz, this.xpp, null);
            }
        }
    }

    public boolean parseBool(String value) throws XmlPullParserException {
        if ("true".equals(value)) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        throw new XmlPullParserException("boolean value must be 'true' or 'false'", this.xpp, null);
    }

    protected int parseInt(String value) throws XmlPullParserException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw (XmlPullParserException)new XmlPullParserException("Unable to parse integer", this.xpp, (Throwable)ex).initCause((Throwable)ex);
        }
    }

    protected float parseFloat(String value) throws XmlPullParserException {
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException ex) {
            throw (XmlPullParserException)new XmlPullParserException("Unable to parse float", this.xpp, (Throwable)ex).initCause((Throwable)ex);
        }
    }

    protected void missingAttribute(String attribute) throws XmlPullParserException {
        throw new XmlPullParserException("missing '" + attribute + "' on '" + this.xpp.getName() + "'", this.xpp, null);
    }

    protected void handleType(int type) {
        this.unusedAttributes.clear();
        switch (type) {
            case 2: {
                this.unusedAttributes.set(0, this.xpp.getAttributeCount());
            }
        }
    }

    protected void warnUnusedAttributes() {
        if (!this.unusedAttributes.isEmpty()) {
            String positionDescription = this.getPositionDescription();
            int i = -1;
            while ((i = this.unusedAttributes.nextSetBit(i + 1)) >= 0) {
                this.getLogger().log(Level.WARNING, "Unused attribute ''{0}'' on ''{1}'' at {2}", new Object[]{this.xpp.getAttributeName(i), this.xpp.getName(), positionDescription});
            }
        }
    }

    protected Logger getLogger() {
        return Logger.getLogger(this.loggerName);
    }

    static class XPPF {
        private static final XmlPullParserFactory xppf;
        private static XmlPullParserException xppfex;

        static XmlPullParser newPullParser() throws XmlPullParserException {
            if (xppf != null) {
                return xppf.newPullParser();
            }
            throw xppfex;
        }

        private XPPF() {
        }

        static {
            XmlPullParserFactory f = null;
            try {
                f = XmlPullParserFactory.newInstance();
                f.setNamespaceAware(false);
                f.setValidating(false);
            }
            catch (XmlPullParserException ex) {
                Logger.getLogger(XMLParser.class.getName()).log(Level.SEVERE, "Unable to construct XmlPullParserFactory", ex);
                xppfex = ex;
            }
            xppf = f;
        }
    }
}

