/**
 * Je Frame wird fuer jedes Vertex der Vertexshader einmal ausgefuehrt. 
 * Der Shader hat dabei nur Zugriff auf den gerade behandelten Vertex
 * (inkl. seiner Texturkoordinaten, Normalen und sonstiger uebergebener Daten), 
 * aber nicht etwa auf Nachbar-Vertices, die Topologie oder aehnliches.
 * 
 * @author Elmar Schug, Andreas Huber, Horst Loepprich
 * @since 04.10.2012
 *
 */

#version 150 core

uniform mat4 projectionMatrix;
uniform mat4 viewMatrix;
uniform mat4 modelMatrix;

uniform vec4 light_Ambient;
uniform vec4 light_Diffuse;

uniform vec4 light_Position;
uniform float light_Intensity;

uniform vec4 spot_Position;
uniform float spot_Intensity;
uniform vec3 spot_Direction;
uniform float spot_Exponent;
uniform float spot_Cutoff;
uniform float constAtt;
uniform float lineaAtt;
uniform float quadAtt;

in vec4 in_position;
in vec3 in_vertexnormal;
in vec3 in_facenormal;
in vec2 in_index;
in vec4 in_color;
in vec2 in_texturcoordinate;

out vec3 pass_light_normal;
out vec3 pass_spot_normal;
out vec2 pass_texturcoordinate;

out vec4 pass_Ambient;
out vec4 pass_Diffuse;

out vec4 pass_vertexVec;
out vec4 pass_lightVec;

out vec4 pass_spot_vertexVec;
out vec4 pass_spot_lightVec;
out float pass_spot_intensity;
out vec3 pass_spot_Direction;
out float pass_spot_Exponent;
out float pass_spot_Cutoff;
out vec3 pass_Eye;
out float pass_constAtt;
out float pass_lineaAtt;
out float pass_quadAtt;

//Uebergabe der Lichtattribute
void passAttributes()
{ 	
	pass_Eye = vec3(spot_Position);
	pass_spot_intensity = spot_Intensity;
	pass_spot_Direction = spot_Direction;
	pass_spot_Exponent = spot_Exponent;
	pass_spot_Cutoff = spot_Cutoff;
	pass_constAtt = constAtt;
	pass_lineaAtt = lineaAtt;
	pass_quadAtt = quadAtt;
	
	pass_Ambient = light_Ambient;//*mat_Ambient;
	pass_Diffuse = light_Diffuse;//*mat_Diffuse;
}

//Uebergabe der Texturkoordinaten
void passTexture()
{
	pass_texturcoordinate = in_texturcoordinate;
}

void main(void)
{
	vec4 spot_Position_tmp = spot_Position;
	spot_Position_tmp.w *= -1.0f;
	
	//Normalmatrix zum Berechnen der Lichtrichtung
	mat3 NormalMatrix = transpose(inverse(mat3(modelMatrix)));
	
	//Berechnung der Sonnenvektoren
	pass_vertexVec = modelMatrix * in_position;	
	pass_lightVec = modelMatrix * light_Position;
	pass_light_normal = normalize(NormalMatrix*in_facenormal);
	
	//Berechnung der Spotvektoren	
	pass_spot_vertexVec = modelMatrix * in_position;
	pass_spot_lightVec = modelMatrix * spot_Position_tmp;		
	pass_spot_normal = normalize(NormalMatrix*normalize(spot_Direction));	
	
	//Berechnung der Vertexpositionen im Worldspace	
	gl_Position = projectionMatrix * viewMatrix * modelMatrix * in_position;
	passTexture();
	passAttributes();
}