/**
 * Der Fragmentshader wird je Frame fuer jedes Fragment (= Pixel bevor sie auf 
 * dem Anzeigegeraet angezeigt werden) einmal ausgefuehrt. 
 * Hier wird die Farbe fuer das entsprechende Fragment berechnet und gesetzt.
 * 
 * @author Elmar Schug, Andreas Huber, Horst Loepprich
 * @since 04.10.2012
 *
 */

#version 150 core

uniform sampler2D texture_diffuse;

in vec2 pass_texturcoordinate;

in vec4 pass_Ambient;
in vec4 pass_Diffuse;

in vec4 pass_vertexVec;
in vec4 pass_lightVec;
in vec3 pass_light_normal;

in vec4 pass_spot_vertexVec;
in vec4 pass_spot_lightVec;
in vec3 pass_spot_normal;
in float pass_spot_intensity;
in vec3 pass_spot_Direction;
in float pass_spot_Exponent;
in float pass_spot_Cutoff;
in float pass_constAtt;
in float pass_lineaAtt;
in float pass_quadAtt;

out vec4 out_Color;

vec4 Ambient;
vec4 Diffuse;

void spotLight(in vec3 normal)
{
	float nDotVP;					//
	float pf;						//
	float spotDot;					//
	float spotAttenuation;			//
	float attenuation;				//
	float dist;						//
	
	vec3 lightDir = normalize(vec3(pass_spot_lightVec - pass_spot_vertexVec));
	dist = length(pass_spot_lightVec);
	
	attenuation = 1.0 / (pass_constAtt + pass_lineaAtt * dist + pass_quadAtt * dist * dist);
	
	spotDot = dot(lightDir, normalize(pass_spot_Direction));
	
	if(spotDot < pass_spot_Cutoff)
	{
		spotAttenuation = 0.0;
	}
	else
	{
		spotAttenuation = pow(spotDot, pass_spot_Exponent);
	}
	
	attenuation *= spotAttenuation;
	
	nDotVP = max(0.0, dot(normal, lightDir));
	
	Ambient += pass_Ambient * attenuation * pass_spot_intensity;
	Diffuse += pass_Diffuse * nDotVP * attenuation * pass_spot_intensity;
}

void directionalLight(in vec3 normal)
{		
	vec3 lightDir = normalize(vec3(pass_lightVec-pass_vertexVec));
	
	Ambient += pass_Ambient;//* pass_light_Intensity;
	Diffuse += pass_Diffuse*max(0.0,dot(normal,lightDir));//* pass_light_intensity;
}

void main()
{
	Ambient = vec4(0.0);
	Diffuse = vec4(0.0);
	
	//Berechnung des Umgebungslichts
	directionalLight(pass_light_normal);
	
	//Berechnung des Spotlichts
	spotLight(pass_spot_normal);	
	
	//Ausgabe der aufgehellten Texturen
	out_Color = (Ambient+Diffuse)*texture(texture_diffuse, pass_texturcoordinate);
}