/**
 * Je Frame wird für jedes Vertex der Vertexshader einmal ausgeführt. 
 * Der Shader hat dabei nur Zugriff auf den gerade behandelten Vertex
 * (inkl. seiner Texturkoordinaten, Normalen und sonstiger übergebener Daten), 
 * aber nicht etwa auf Nachbar-Vertices, die Topologie oder Ähnliches.
 * 
 * @author Elmar Schug, Andreas Huber
 * @since 04.10.2012
 *
 */

#version 150 core

uniform mat4 projectionMatrix;

in vec4 in_position;
in vec2 in_texturcoordinate;

out vec4 pass_color;
out vec2 pass_texturcoordinate;

void main(void)
{
	gl_Position = projectionMatrix * in_position;

	pass_texturcoordinate = in_texturcoordinate;
}